<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="h-full bg-gray-100">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'UBOrtimo')); ?></title>

    <!-- Fonts -->
    
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.3.1/css/all.css" integrity="sha384-mzrmE5qonljUremFsqc01SB46JvROS7bZs3IO2EmfFsd15uHvIt+Y8vEf7N7fWAU" crossorigin="anonymous">
    <link rel="stylesheet" href="https://rsms.me/inter/inter.css">
    <!-- Styles -->
    <!-- Alpine -->
    <link rel="stylesheet" href="<?php echo e(mix('css/app.css')); ?>">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@tailwindcss/ui@latest/dist/tailwind-ui.min.css">
    <script src="https://cdn.jsdelivr.net/gh/alpinejs/alpine@v2.x.x/dist/alpine.min.js" defer></script>
    <?php echo \Livewire\Livewire::styles(); ?>


    <!-- Scripts -->

    <?php echo $__env->yieldContent('style'); ?>
</head>
<body class="h-full">
<div class="min-h-full">
    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('navigation-menu', ['menuitems' => $menuitems])->html();
} elseif ($_instance->childHasBeenRendered('Xl0VSVV')) {
    $componentId = $_instance->getRenderedChildComponentId('Xl0VSVV');
    $componentTag = $_instance->getRenderedChildComponentTagName('Xl0VSVV');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('Xl0VSVV');
} else {
    $response = \Livewire\Livewire::mount('navigation-menu', ['menuitems' => $menuitems]);
    $html = $response->html();
    $_instance->logRenderedChild('Xl0VSVV', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
    <?php if (isset($component)) { $__componentOriginale945de8d7b2d40fe71da40b4423dea30ae4cdee7 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\HeaderBreadCrumbs::class, []); ?>
<?php $component->withName('header-bread-crumbs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale945de8d7b2d40fe71da40b4423dea30ae4cdee7)): ?>
<?php $component = $__componentOriginale945de8d7b2d40fe71da40b4423dea30ae4cdee7; ?>
<?php unset($__componentOriginale945de8d7b2d40fe71da40b4423dea30ae4cdee7); ?>
<?php endif; ?>
    <div class="py-1">

        <?php if(isset($header)): ?>
            <header>
                <div class="max-w-12xl mx-auto px-4 sm:px-6 lg:px-8">
                    <h1 class="font-bold leading-tight text-gray-900">
                        <?php echo e($header); ?>

                    </h1>
                </div>
            </header>
        <?php endif; ?>
        <main>
            <div class="max-w-12xl mx-auto sm:px-6 lg:px-8">
                <!-- Replace with your content -->
            <?php echo e($slot); ?>

            <!-- /End replace -->
            </div>
        </main>

    </div>
</div>
<footer class="bg-white">
    <div class="max-w-12xl mx-auto py-1 px-4 sm:px-6 md:flex md:items-center md:justify-between lg:px-8">
        <div class="mt-8 md:mt-0 md:order-1">
            <p class="text-center text-base text-gray-400">
                &copy; <?php echo e(date('Y')); ?> UBOrtimo. Software by Ortimo </p>
        </div>
    </div>
</footer>
<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.notification','data' => []]); ?>
<?php $component->withName('notification'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.notificationgreen','data' => []]); ?>
<?php $component->withName('notificationgreen'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.notificationerror','data' => []]); ?>
<?php $component->withName('notificationerror'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php echo \Livewire\Livewire::scripts(); ?></livewire:scripts>
<script src="https://unpkg.com/flowbite@1.3.4/dist/flowbite.js"></script>

</body>
</html>
<?php /**PATH /Users/soneraltin/Documents/websites/UBOrtimo/resources/views/layouts/app.blade.php ENDPATH**/ ?>