<div>
    <div class="pb-4">
        <div class="sm:hidden">
            <label for="tabs" class="sr-only">Select a tab</label>
            <!-- Use an "onChange" listener to redirect the user to the selected tab URL. -->
            <select id="tabs" name="tabs" class="block w-full focus:ring-indigo-500 focus:border-indigo-500 border-gray-300 rounded-md">
                <option selected>Gegevens</option>
                <option>Betaalinfo</option>
                <option>Identificatie</option>
                <option>Fase/keten</option>
                <option>Loonstroken</option>
                <option>Contract</option>
            </select>
        </div>
        <div class="hidden sm:block">
            <nav class="relative z-0 rounded-lg shadow flex divide-x divide-gray-200" aria-label="Tabs">
                <!-- Current: "text-gray-900", Default: "text-gray-500 hover:text-gray-700" -->
                <?php $__currentLoopData = $tabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a wire:click="changeTab('<?php echo e($tab); ?>')" class="<?php if($currentTab == $tab): ?> text-gray-900 rounded-l-lg <?php else: ?> text-gray-500 hover:text-gray-700 <?php endif; ?> cursor-pointer group relative min-w-0 flex-1 overflow-hidden bg-white py-4 px-4 text-sm font-medium text-center hover:bg-gray-50 focus:z-10">
                        <span><?php echo e($tab); ?></span>
                        <span aria-hidden="true" class="<?php if($currentTab == $tab): ?> bg-blue-500 <?php else: ?> bg-transparent <?php endif; ?> absolute inset-x-0 bottom-0 h-0.5"></span>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </nav>
        </div>
    </div>
    <div x-data="{ currenttab: <?php if ((object) ('currentTab') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($_instance->id); ?>').entangle('<?php echo e('currentTab'->value()); ?>')<?php echo e('currentTab'->hasModifier('defer') ? '.defer' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($_instance->id); ?>').entangle('<?php echo e('currentTab'); ?>')<?php endif; ?>}">
        <div x-show="currenttab=='Gegevens'" style="display: none;">
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('employees.employee-basic-info', ['employee' => $employee])->html();
} elseif ($_instance->childHasBeenRendered('l2379424597-0')) {
    $componentId = $_instance->getRenderedChildComponentId('l2379424597-0');
    $componentTag = $_instance->getRenderedChildComponentTagName('l2379424597-0');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('l2379424597-0');
} else {
    $response = \Livewire\Livewire::mount('employees.employee-basic-info', ['employee' => $employee]);
    $html = $response->html();
    $_instance->logRenderedChild('l2379424597-0', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
        </div>
        <div x-show="currenttab=='Betaalinfo'" style="display: none;">
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('employees.employee-bank', ['employee' => $employee])->html();
} elseif ($_instance->childHasBeenRendered('l2379424597-1')) {
    $componentId = $_instance->getRenderedChildComponentId('l2379424597-1');
    $componentTag = $_instance->getRenderedChildComponentTagName('l2379424597-1');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('l2379424597-1');
} else {
    $response = \Livewire\Livewire::mount('employees.employee-bank', ['employee' => $employee]);
    $html = $response->html();
    $_instance->logRenderedChild('l2379424597-1', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
        </div>
    </div>
</div>
<?php /**PATH /Users/soneraltin/Documents/websites/UBOrtimo/resources/views/livewire/employees/employee-tabs.blade.php ENDPATH**/ ?>