<?php

use App\Http\Controllers\CompanyController;
use App\Http\Controllers\LogsActivity;
use Employees\Controllers\EmployeeController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => ['auth:sanctum', 'verified']], function (){
    Route::get('/', function () {return view('dashboard');});
    Route::get('/dashboard', function (){ return view('dashboard'); })->name('dashboard');
    Route::resource('/logs', LogsActivity::class)->only('index');
});
Route::get('/artisan', [\App\Http\Controllers\ArtisanCommandsController::class, 'index']);
Route::get('/artisan/dmfs', [\App\Http\Controllers\ArtisanCommandsController::class, 'databaseMigrateFreshSeed'])->name('migratefreshseed');
Route::get('/artisan/databaseMigrateFresh', [\App\Http\Controllers\ArtisanCommandsController::class, 'databaseMigrateFresh'])->name('databaseMigrateFresh');
Route::get('/artisan/databaseSeed', [\App\Http\Controllers\ArtisanCommandsController::class, 'databaseSeed'])->name('databaseSeed');
Route::get('/artisan/databaseMigrateSeed', [\App\Http\Controllers\ArtisanCommandsController::class, 'databaseMigrateSeed'])->name('databaseMigrateSeed');
Route::get('/artisan/cacheClear', [\App\Http\Controllers\ArtisanCommandsController::class, 'cacheClear'])->name('cacheClear');
Route::get('/artisan/optimizeClear', [\App\Http\Controllers\ArtisanCommandsController::class, 'optimizeClear'])->name('optimizeClear');
Route::get('/artisan/optimize', [\App\Http\Controllers\ArtisanCommandsController::class, 'optimize'])->name('optimize');
