<div>
    <div class="max-w-12xl mx-auto sm:px-0 lg:px-0">
        <!-- This example requires Tailwind CSS v2.0+ -->
        <div class="flex flex-col">
            <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                <div class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8">
                    <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg my-2">
                        <x-table.table>
                            <x-slot name="head">
                                <x-table.heading class="pr-0 w-8 text-left">
                                    {{__('Waar')}}
                                </x-table.heading>
                                <x-table.heading class="pr-0 w-8 text-left">
                                    {{__('Wanneer')}}
                                </x-table.heading>
                                <x-table.heading class="pr-0 w-8 text-left">
                                    {{__('Handeling')}}
                                </x-table.heading>
                                <x-table.heading class="pr-0 w-8 text-left">
                                    {{__('Wie')}}
                                </x-table.heading>
                                <x-table.heading class="pr-0 w-8 text-left">
                                </x-table.heading>
                            </x-slot>
                            <x-slot name="body">
                                @forelse($logs as $key => $log)
                                    <x-table.row wire:loading.delay.class="opacity-50">
                                        <x-table.cell>
                                            {{__($log->subject_type)}}
                                        </x-table.cell>
                                        <x-table.cell>
                                            {{$log->created_at}}
                                        </x-table.cell>
                                        <x-table.cell>
                                            @switch($log->event)
                                                @case('created')
                                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-blue-100 text-blue-800">
                                                  {{__($log->event)}}
                                                </span>
                                                @break
                                                @case('updated')
                                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-orange-100 text-orange-800">
                                                  {{__($log->event)}}
                                                </span>
                                                @break
                                                @case('deleted')
                                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-red-100 text-red-800">
                                                  {{__($log->event)}}
                                                </span>
                                                @break
                                                @default
                                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-blue-100 text-blue-800">
                                                  {{__($log->event)}}
                                                </span>
                                                @break
                                            @endswitch
                                        </x-table.cell>
                                        <x-table.cell>
                                            {{$log->causer_name}}
                                        </x-table.cell>
                                        <x-table.cell>
                                            @if(isset($detailopen[$key]))
                                                <x-button.secondary wire:click="closeDetails()">{{__('Details sluiten')}}</x-button.secondary>
                                            @else
                                                <x-button.secondary wire:click="openDetails({{$log}}, {{$key}})">{{__('Details openen')}}</x-button.secondary>
                                            @endif

                                        </x-table.cell>
                                    </x-table.row>
                                    @if(isset($detailopen[$key]))
                                        <x-table.row>
                                            <x-table.cell colspan="5" class="bg-slate-200 py-8">




                                                <x-table.table>
                                                    <x-slot name="head">
                                                        <x-table.heading class="pr-0 w-8 text-left bg-slate-500">
                                                            <span class="text-white">{{__('Veld')}}</span>
                                                        </x-table.heading>
                                                        <x-table.heading class="pr-0 w-8 text-left bg-slate-500">
                                                            <span class="text-white">{{__('Oude waarde')}}</span>
                                                        </x-table.heading>
                                                        <x-table.heading class="pr-0 w-8 text-left bg-slate-500">
                                                            <span class="text-white">{{__('Nieuwe waarde')}}</span>
                                                        </x-table.heading>
                                                    </x-slot>
                                                    <x-slot name="body">
                                                        @if(isset($logdetails['old']))
                                                            @foreach($logdetails['old'] as $key => $old)
                                                                <x-table.row>
                                                                    <x-table.cell>{{$key}}</x-table.cell>
                                                                    <x-table.cell>{{$old}}</x-table.cell>
                                                                    <x-table.cell>{{isset($logdetails['attributes']) ? $logdetails['attributes'][$key] : ''}}</x-table.cell>
                                                                </x-table.row>
                                                            @endforeach
                                                        @else
                                                            @foreach($logdetails['attributes'] as $key => $old)
                                                                <x-table.row>
                                                                    <x-table.cell>{{$key}}</x-table.cell>
                                                                    <x-table.cell>{{$old}}</x-table.cell>
                                                                    <x-table.cell>{{isset($logdetails['old']) ? $logdetails['old'][$key] : ''}}</x-table.cell>
                                                                </x-table.row>
                                                            @endforeach
                                                        @endif
                                                    </x-slot>

                                                </x-table.table>
                                            </x-table.cell>
                                        </x-table.row>
                                    @endif
                                @empty
                                    <x-table.row>
                                        <x-table.cell colspan="7">
                                            <div class="flex justify-center items-center">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="inline-block text-cool-gray-300 mx-2 h-8 w-8" fill="currentColor" viewBox="0 0 24 24">
                                                    <path fill-rule="evenodd" d="M4 4a2 2 0 012-2h4.586A2 2 0 0112 2.586L15.414 6A2 2 0 0116 7.414V16a2 2 0 01-2 2H6a2 2 0 01-2-2V4zm2 6a1 1 0 011-1h6a1 1 0 110 2H7a1 1 0 01-1-1zm1 3a1 1 0 100 2h6a1 1 0 100-2H7z" clip-rule="evenodd" />
                                                </svg>
                                                <span class="text-xl text-cool-gray-400 py-8 font-medium">{{__('Geen logs gevonden...')}}</span>
                                            </div>
                                        </x-table.cell>
                                    </x-table.row>
                                @endforelse
                            </x-slot>
                        </x-table.table>
                    </div>
                    {{$logs->links()}}
                </div>
            </div>
        </div>
    </div>
</div>
