<div>
    <div class="bg-white shadow overflow-hidden sm:rounded-lg">
        <div class="px-4 py-5 sm:px-6">
            <h3 class="text-lg leading-6 font-medium text-gray-900 flex items-center justify-between">
                {{__('Gegevens')}}
                <x-button.link wire:click="edit" class="h-8 w-8 rounded-full hover:bg-gray-100 hover:text-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-50"><x-icon.edit></x-icon.edit></x-button.link>
            </h3>
            <p class="mt-1 max-w-2xl text-sm text-gray-500">
                {{__('Alle persoonlijke gegevens van de medewerker')}}
            </p>
        </div>
        <div class="border-t border-gray-200">
            <dl>
                <div class="bg-gray-50 px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                    <dt class="text-sm font-medium text-gray-500">
                        BSN
                    </dt>
                    <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2 flex justify-between">
                        @if($showBsn)
                            {{$basicinfo->bsn}}
                            <x-icon.eyeslash wire:click="$toggle('showBsn')" class="ml-4 pt-1 text-cool-gray-500 cursor-pointer"></x-icon.eyeslash>
                        @else
                            @bsn($basicinfo->bsn)
                            <x-icon.eye wire:click="$toggle('showBsn')" class="ml-4 pt-1 text-cool-gray-500 cursor-pointer"></x-icon.eye>
                        @endif

                    </dd>
                </div>
                <div class="bg-gray-50 px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                    <dt class="text-sm font-medium text-gray-500">
                        {{__('Geboorte Plaats/Land')}}
                    </dt>
                    <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                        {{$basicinfo->birthplace}} / {{$basicinfo->birthland}}
                    </dd>
                </div>
                <div class="bg-white px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                    <dt class="text-sm font-medium text-gray-500">
                        {{__('Burgerlijke staat')}}
                    </dt>
                    <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                        {{$basicinfo->marital_status}}
                    </dd>
                </div>
                <div class="bg-white px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                    <dt class="text-sm font-medium text-gray-500">
                        {{__('Schoenmaat')}}
                    </dt>
                    <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                        {{$extrainfo->shoe_size}}
                    </dd>
                </div>
                <div class="bg-white px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                    <dt class="text-sm font-medium text-gray-500">
                        {{__('Vervoer')}}
                    </dt>
                    <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                        {{$extrainfo->transport}}
                    </dd>
                </div>
                <div class="bg-white px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                    <dt class="text-sm font-medium text-gray-500">
                        {{__('Rijbewijs')}}
                    </dt>
                    <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                        {{$extrainfo->drivers_license}}
                    </dd>
                </div>
                <div class="bg-white px-4 py-2 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                    <dt class="text-sm font-medium text-gray-500">
                        {{__('VOG')}}
                    </dt>
                    <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                        @if($extrainfo->vog)
                            <x-icon.check class="text-green-500"></x-icon.check>
                        @else
                            <x-icon.ban class="text-red-500"></x-icon.ban>
                        @endif
                    </dd>
                </div>
            </dl>
        </div>
    </div>

    <form wire:submit.prevent="saveBasicInfo">
        <x-modal.dialog wire:model.defer="showBasicInfoModal" maxWidth="7xl">
            <x-slot name="title">{{__('Medewerken informatie bewerken')}}</x-slot>
            <x-slot name="content">
                <div class="mt-10 sm:mt-0">
                    <div class="md:grid md:grid-cols-3 md:gap-6">
                        <div class="md:col-span-1">
                            <div class="px-4 sm:px-0">
                                <h3 class="text-lg font-medium leading-6 text-gray-900">{{__('Persoonlijke informatie')}}</h3>
                                <p class="mt-1 text-sm text-gray-600">
                                    {{__('Alle persoonlijke informatie van de werknemer')}}
                                </p>
                            </div>
                        </div>
                        <div class="mt-5 md:mt-0 md:col-span-2">
                            <div class="grid grid-cols-6 gap-6">
                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="name" inline="true" label="{{__('BSN')}}" :error="$errors->first('basicinfoediting.bsn')">
                                        <x-inputs.text wire:model.defer="basicinfoediting.bsn"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="name" inline="true" label="{{__('Burgerlijke staat')}}" :error="$errors->first('basicinfoediting.marital_status')">
                                        <x-inputs.text wire:model.defer="basicinfoediting.marital_status"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                            </div>
                            <div class="grid grid-cols-6 gap-6 my-4">
                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="name" inline="true" label="{{__('Geboorteplaats')}}" :error="$errors->first('basicinfoediting.birthplace')">
                                        <x-inputs.text wire:model.defer="basicinfoediting.birthplace"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="name" inline="true" label="{{__('Geboorteland')}}" :error="$errors->first('basicinfoediting.birthland')">
                                        <x-inputs.text wire:model.defer="basicinfoediting.birthland"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr class="my-8">
                    <div class="md:grid md:grid-cols-3 md:gap-6">
                        <div class="md:col-span-1">
                            <div class="px-4 sm:px-0">
                                <h3 class="text-lg font-medium leading-6 text-gray-900">{{__('Extra gegevens')}}</h3>
                                <p class="mt-1 text-sm text-gray-600">
                                    {{__('Alle extra gegevens van de werknemer')}}
                                </p>
                            </div>
                        </div>
                        <div class="mt-5 md:mt-0 md:col-span-2">
                            <div class="grid grid-cols-6 gap-6 my-4">
                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="address" inline="true" label="{{__('Schoenmaat')}}" :error="$errors->first('extrainfoediting.shoe_size')">
                                        <x-inputs.select wire:model.defer="extrainfoediting.shoe_size">
                                            @for($i=30; $i<=48;$i++)
                                            <option value="{{$i}}">{{$i}}</option>
                                            @endfor
                                        </x-inputs.select>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="address" inline="true" label="{{__('Vervoer')}}" :error="$errors->first('extrainfoediting.transport')">
                                        <x-inputs.select wire:model.defer="extrainfoediting.transport">
                                            <option value="{{__('Privé')}}">{{__('Privé')}}</option>
                                            <option value="{{__('Bedrijf')}}">{{__('Bedrijf')}}</option>
                                        </x-inputs.select>
                                    </x-inputs.group>
                                </div>
                            </div>
                            <div class="grid grid-cols-6 gap-6 my-4">
                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="address" inline="true" label="{{__('Rijbewijs')}}" :error="$errors->first('extrainfoediting.drivers_license')">
                                        <x-inputs.select wire:model.defer="extrainfoediting.drivers_license">
                                            <option value="A">A</option>
                                            <option value="A1">A1</option>
                                            <option value="A2">A2</option>
                                            <option value="B">B</option>
                                            <option value="C">C</option>
                                        </x-inputs.select>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="address" inline="true" label="{{__('VOG')}}" :error="$errors->first('extrainfoediting.vog')">
                                        <input type="checkbox" wire:model.defer="extrainfoediting.vog">
                                    </x-inputs.group>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </x-slot>
            <x-slot name="footer">
                <x-button.secondary wire:click="$set('showBasicInfoModal', false)">{{__('Annuleren')}}</x-button.secondary>
                <x-button.primary type="submit">{{__('Opslaan')}}</x-button.primary>
            </x-slot>
        </x-modal.dialog>
    </form>


</div>
