<div>
    <section aria-labelledby="plan-heading">
        <div class="shadow sm:rounded-md sm:overflow-hidden">
            <div class="bg-white py-6 px-4 space-y-6 sm:p-6">
                <div class="flex items-center justify-between">
                    <h2 class="text-lg leading-6 font-medium text-gray-900 flex justify-between">
                        {{__('Banken')}}
                        @if($showBankNumbers)
                            <x-icon.eyeslash wire:click="$toggle('showBankNumbers')" class="ml-4 pt-1 text-cool-gray-500 cursor-pointer"></x-icon.eyeslash>
                        @else
                            <x-icon.eye wire:click="$toggle('showBankNumbers')" class="ml-4 pt-1 text-cool-gray-500 cursor-pointer"></x-icon.eye>
                        @endif
                    </h2>
                    <x-buttonicon.link wire:click="addBank()" class="text-blue-500">
                        <x-icon.plus></x-icon.plus> {{__('Toevoegen')}}
                    </x-buttonicon.link>
                </div>

                <fieldset>
                    <legend class="sr-only">
                        {{__('Banken')}}
                    </legend>
                    <div class="relative bg-white rounded-md -space-y-px ">
                        <!-- Checked: "bg-orange-50 border-orange-200 z-10", Not Checked: "border-gray-200" -->
                        @foreach($employee->bank_information as $bank)
                            <div class="grid grid-cols-9">
                                <div class="col-span-7 md:h-20">
                                    <label class="md:h-20 @if($bank->main_bank) bg-sky-50 border-sky-200 z-5 @else border-gray-200 @endif @if($loop->first) rounded-tl-md @endif @if($loop->last) rounded-bl-md @endif relative border p-4 flex flex-col cursor-pointer md:pl-4 md:pr-6 md:grid md:grid-cols-3 focus:outline-none">
                                    <div class="flex items-center text-sm">
                                        <input wire:change="changeMainBank({{$bank->id}})" @if($bank->main_bank) checked @endif type="radio" class="h-4 w-4 text-sky-500 border-gray-300 focus:ring-gray-900" aria-labelledby="pricing-plans-0-label" aria-describedby="pricing-plans-0-description-0 pricing-plans-0-description-1">
                                        <span class="ml-3 font-medium @if($bank->main_bank) text-sky-900 @else text-gray-900 @endif">
                                           @if($showBankNumbers) {{$bank->iban}} @else @maskbank($bank->iban) @endif

                                            <br>
                                            <small class="@if($bank->main_bank) text-sky-700 @else text-gray-500 @endif">{{$bank->bic}}</small>
                                        </span>
                                    </div>
                                    <p class="ml-6 pl-1 text-sm md:ml-0 md:pl-0">
                                        <!-- Checked: "text-orange-900", Not Checked: "text-gray-900" -->
                                        <span class="@if($bank->main_bank) text-sky-900 @else text-gray-900 @endif font-medium">
                                            <span>{{__('Eigenaar')}}:</span>{{$bank->owner}}
                                        </span>
                                        <!-- Checked: "text-orange-700", Not Checked: "text-gray-500" --><br>
                                        <span class="@if($bank->main_bank) text-sky-700 @else text-gray-500 @endif">
                                            <span>{{__('Bank')}}:</span> {{$bank->bank}}</span>
                                    </p>
                                    <!-- Checked: "text-orange-700", Not Checked: "text-gray-500" -->
                                    <p class="ml-6 pl-1 text-sm md:ml-0 md:pl-0 md:text-right @if($bank->main_bank) text-sky-700 @else text-gray-500 @endif">
                                        <span>{{__('Geldig tot')}}</span><br>
                                        {{$bank->valid_until}}
                                    </p>

                                </label>
                                </div>
                                <div class="md:h-20 col-span-2 sm:h-full">
                                    <label class="md:h-20 @if($bank->main_bank) bg-sky-50 border-sky-200 z-5 @else border-gray-200 @endif @if($loop->first) rounded-tr-md @endif @if($loop->last) rounded-br-md @endif relative border p-4 flex items-center justify-end md:pl-4 md:pr-6 focus:outline-none">
                                        <div class="text-sm text-right">
                                            <x-button.link textcolor="text-blue-500" wire:click="edit({{$bank}})">{{__('Bewerken')}}</x-button.link>
                                            <x-button.link textcolor="text-red-500" wire:click="showDeleteBankModalMethod({{$bank}})">{{__('Verwijderen')}}</x-button.link>
                                        </div>
                                    </label>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </fieldset>
            </div>
        </div>
    </section>

{{--<div wire:init>--}}
{{--    --}}
{{--    <section aria-labelledby="applicant-information-title" class="space-y-6 lg:col-start-1 lg:col-span-1">--}}
{{--        <div class="bg-white shadow sm:rounded-lg">--}}
{{--            <div class="px-4 py-5 sm:px-6">--}}
{{--                <h2 class="text-lg leading-6 font-medium text-gray-900 flex items-center justify-between">--}}
{{--                    {{__('Bankgegevens')}}--}}

{{--                </h2>--}}
{{--                <p class="mt-1 max-w-2xl text-sm text-gray-500">{{__('Bank informatie van de medewerker')}}</p>--}}

{{--            </div>--}}
{{--            <div class="border-t border-gray-200 px-4 py-5 sm:px-6">--}}
{{--                <x-table.table>--}}
{{--                    <x-slot name="head">--}}
{{--                        <x-table.heading class="text-left">IBAN</x-table.heading>--}}
{{--                        <x-table.heading class="text-left">Eigenaar</x-table.heading>--}}
{{--                        <x-table.heading class="text-left">Bank</x-table.heading>--}}
{{--                        <x-table.heading class="text-left">Geldig tot</x-table.heading>--}}
{{--                        <x-table.heading class="text-left"></x-table.heading>--}}
{{--                    </x-slot>--}}
{{--                    <x-slot name="body">--}}
{{--                        @foreach($employee->bank_information as $bank)--}}
{{--                            <x-table.row>--}}
{{--                                <x-table.cell>--}}
{{--                                    <span @if(!$bank->main_bank) class="text-cool-gray-400"@endif>--}}
{{--                                        {{$bank->iban}}<br><small>{{$bank->bic}}</small>--}}
{{--                                    </span>--}}
{{--                                </x-table.cell>--}}
{{--                                <x-table.cell><span @if(!$bank->main_bank) class="text-cool-gray-400"@endif>{{$bank->owner}}</span></x-table.cell>--}}
{{--                                <x-table.cell><span @if(!$bank->main_bank) class="text-cool-gray-400"@endif>{{$bank->bank}}</span></x-table.cell>--}}
{{--                                <x-table.cell><span @if(!$bank->main_bank) class="text-cool-gray-400"@endif>{{$bank->valid_until}}</span></x-table.cell>--}}
{{--                                <x-table.cell>--}}
{{--                                    <x-button.link textcolor="text-blue-500" wire:click="edit({{$bank}})">{{__('Bewerken')}}</x-button.link>--}}
{{--                                    |--}}
{{--                                    <x-button.link textcolor="text-red-500" wire:click="showDeleteBankModalMethod({{$bank}})">{{__('Verwijderen')}}</x-button.link>--}}
{{--                                </x-table.cell>--}}
{{--                            </x-table.row>--}}
{{--                        @endforeach--}}
{{--                    </x-slot>--}}
{{--                </x-table.table>--}}
{{--            </div>--}}
{{--        </div>--}}
{{--    </section>--}}


<!-- Bewerken en toevoegen modal -->
    <form wire:submit.prevent="saveBank">
        <x-modal.dialog wire:model.defer="showEditBankModal" maxWidth="2xl">
            <x-slot name="title">{{__('Bank gegevens toevoegen')}}</x-slot>
            <x-slot name="content">
                <div class="mt-10 sm:mt-0">
                    <div class="md:grid md:grid-cols-3 md:gap-6">
                        <div class="md:col-span-1">
                            <div class="px-4 sm:px-0">
                                <h3 class="text-lg font-medium leading-6 text-gray-900">{{__('Bank gevens')}}</h3>
                            </div>
                        </div>
                        <div class="mt-5 md:mt-0 md:col-span-2">
                            <div class="grid grid-cols-6 gap-6">
                                <div class="col-span-6 sm:col-span-6">
                                    <x-inputs.group for="iban" inline="true" label="{{__('IBAN')}}" :error="$errors->first('editing.iban')">
                                        <x-inputs.text wire:model.defer="editing.iban"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-6 sm:col-span-6">
                                    <x-inputs.group for="Simar25pass1." inline="true" label="{{__('BIC/SWIFT')}}" :error="$errors->first('editing.bic')">
                                        <x-inputs.text wire:model.defer="editing.bic"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-6 sm:col-span-6">
                                    <x-inputs.group for="owner" inline="true" label="{{__('Eigenaar')}}" :error="$errors->first('editing.owner')">
                                        <x-inputs.text wire:model.defer="editing.owner"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-6 sm:col-span-6">
                                    <x-inputs.group for="bank" inline="true" label="{{__('Naam van bank')}}" :error="$errors->first('editing.bank')">
                                        <x-inputs.text wire:model.defer="editing.bank"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-6 sm:col-span-6">
                                    <x-inputs.group for="valid_until" inline="true" label="{{__('Geldig tot')}}" :error="$errors->first('editing.valid_until')">
                                        <x-inputs.text wire:model.defer="editing.valid_until"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </x-slot>
            <x-slot name="footer">
                <x-button.secondary wire:click="$set('showEditBankModal', false)">{{__('Annuleren')}}</x-button.secondary>
                <x-button.primary type="submit">{{__('Opslaan')}}</x-button.primary>
            </x-slot>
        </x-modal.dialog>
    </form>

    <!-- Confirm modal -->
    <form wire:submit.prevent="deleteBank">
        <x-modal.confirmation wire:model.defer="showDeleteModal">
            <x-slot name="title">{{__('Bank verwijderen')}}</x-slot>
            <x-slot name="content">{{__('Deze actie kan niet ongedaan worden gemaakt.')}}</x-slot>
            <x-slot name="footer">
                <x-button.danger type="submit">{{__('Verwijderen')}}</x-button.danger>
                <x-button.secondary wire:click="$set('showDeleteModal', false)">{{__('Annuleren')}}</x-button.secondary>
            </x-slot>
        </x-modal.confirmation>
    </form>
</div>

