<div>
    <div class="mx-auto md:flex md:items-center justify-end py-2">
        <div class="mt-6 flex flex-col-reverse justify-stretch space-y-4 space-y-reverse sm:flex-row-reverse sm:justify-end sm:space-x-reverse sm:space-y-0 sm:space-x-3 md:mt-0 md:flex-row md:space-x-3">
            <x-button.primary wire:click="addContactPerson"><x-icon.plus></x-icon.plus> Contactpersoon Toevoegen</x-button.primary>
        </div>
    </div>
    <x-table.table>
        <x-slot name="head">
            <x-table.heading class="pr-0 w-8">
                {{__('Naam')}}
            </x-table.heading>
            <x-table.heading class="pr-0 w-8">
                {{__('Functie')}}
            </x-table.heading>
            <x-table.heading class="pr-0 w-8">
                {{__('Email')}}
            </x-table.heading>
            <x-table.heading class="pr-0 w-8">
                {{__('Telefoon')}}
            </x-table.heading>
            <x-table.heading class="pr-0 w-8">
                {{__('Notitie')}}
            </x-table.heading>
            <x-table.heading class="pr-0 w-8"></x-table.heading>
        </x-slot>
        <x-slot name="body">
            @forelse($company->contact_person as $contact_person)
                <x-table.row wire:loading.delay.class="opacity-50" wire:key="row-{{$contact_person->id}}">
                    <x-table.cell>
                        {{$contact_person->name}}
                    </x-table.cell>
                    <x-table.cell>
                        {{$contact_person->company_function}}
                    </x-table.cell>
                    <x-table.cell>
                        <a href="mailto:{{$contact_person->email}}">{{$contact_person->email}}</a>
                    </x-table.cell>
                    <x-table.cell>
                        <a href="tel:{{$contact_person->phone}}">{{$contact_person->phone}}</a>
                    </x-table.cell>
                    <x-table.cell>
                        <span style="white-space: break-spaces;">{{$contact_person->note}}</span>
                    </x-table.cell>
                    <x-table.cell>
                        <div class="flex justify-between items-center">
                            <x-button.link wire:click="edit({{$contact_person}})" class="text-blue-500">{{__('Bewerken')}}</x-button.link>
                            <x-button.link wire:click="showDeleteContactPersonModalMethod({{$contact_person}})" class="text-red-500">{{__('Verwijderen')}}</x-button.link>
                        </div>
                    </x-table.cell>
                </x-table.row>
            @empty
                <x-table.row wire:loading.delay.class="opacity-50">
                    <x-table.cell colspan="6">
                        <div class="flex justify-center items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="inline-block text-cool-gray-300 mx-2 h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.121 17.804A13.937 13.937 0 0112 16c2.5 0 4.847.655 6.879 1.804M15 10a3 3 0 11-6 0 3 3 0 016 0zm6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <span class="text-xl text-cool-gray-400 py-8 font-medium">{{__('Geen contactpersonen gevonden...')}}</span>
                        </div>
                    </x-table.cell>
                </x-table.row>
            @endforelse
        </x-slot>
    </x-table.table>
    <form wire:submit.prevent="saveContactPerson">
        <x-modal.dialog wire:model.defer="showEditContactPersonModal" maxWidth="2xl">
            <x-slot name="title">{{__('Contactpersoon toevoegen')}}</x-slot>
            <x-slot name="content">
                <div class="mt-10 sm:mt-0">
                    <div class="md:grid md:grid-cols-3 md:gap-6">
                        <div class="md:col-span-1">
                            <div class="px-4 sm:px-0">
                                <h3 class="text-lg font-medium leading-6 text-gray-900">{{__('Contactpersoon gevens')}}</h3>
                            </div>
                        </div>
                        <div class="mt-5 md:mt-0 md:col-span-2">
                            <div class="grid grid-cols-6 gap-6">
                                <div class="col-span-6 sm:col-span-6">
                                    <x-inputs.group for="name" inline="true" label="{{__('Naam')}}" :error="$errors->first('editing.name')">
                                        <x-inputs.text wire:model.defer="editing.name"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-6 sm:col-span-6">
                                    <x-inputs.group for="company_function" inline="true" label="{{__('Functie')}}" :error="$errors->first('editing.company_function')">
                                        <x-inputs.text wire:model.defer="editing.company_function"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-6 sm:col-span-6">
                                    <x-inputs.group for="email" inline="true" label="{{__('Email')}}" :error="$errors->first('editing.email')">
                                        <x-inputs.text wire:model.defer="editing.email"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-6 sm:col-span-6">
                                    <x-inputs.group for="phone" inline="true" label="{{__('Telefoon')}}" :error="$errors->first('editing.phone')">
                                        <x-inputs.text wire:model.defer="editing.phone"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-6 sm:col-span-6">
                                    <x-inputs.group for="note" inline="true" label="{{__('Notitie')}}" :error="$errors->first('editing.note')">
                                        <x-inputs.textarea wire:model.defer="editing.note"></x-inputs.textarea>
                                    </x-inputs.group>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </x-slot>
            <x-slot name="footer">
                <x-button.secondary wire:click="$set('showEditContactPersonModal', false)">{{__('Annuleren')}}</x-button.secondary>
                <x-button.primary type="submit">{{__('Opslaan')}}</x-button.primary>
            </x-slot>
        </x-modal.dialog>
    </form>

    <!-- Confirm modal -->
    <form wire:submit.prevent="deleteContactPerson">
        <x-modal.confirmation wire:model.defer="showDeleteModal">
            <x-slot name="title">{{__('Contactpersoon verwijderen')}}</x-slot>
            <x-slot name="content">{{__('Deze actie kan niet ongedaan worden gemaakt.')}}</x-slot>
            <x-slot name="footer">
                <x-button.danger type="submit">{{__('Verwijderen')}}</x-button.danger>
                <x-button.secondary wire:click="$set('showDeleteModal', false)">{{__('Annuleren')}}</x-button.secondary>
            </x-slot>
        </x-modal.confirmation>
    </form>
</div>
