<div>
    <section>
        <form wire:submit.prevent="saveCompanyBasicInfo">
            <div class="shadow sm:rounded-md sm:overflow-hidden">
                <div class="bg-white py-6 px-4 sm:p-6">
                    <div>
                        <h2 id="payment-details-heading" class="text-lg leading-6 font-medium text-gray-900">
                            {{__('Bedrijfsgegevens')}}
                            <x-button.link wire:click="$toggle('editValues')"><small> @if(!$editValues) <span class="text-orange-400">{{__('Bewerken')}}</span> @endif</small></x-button.link>
                        </h2>
                        <p class="mt-1 text-sm text-gray-500">Alle basis bedrijfsgegevens van het bedrijf</p>
                    </div>

                    <div class="mt-6 grid grid-cols-4 gap-6">
                        <div class="col-span-4 sm:col-span-4">
                            <x-inputs.group required for="name" inline="true" label="{{__('Bedrijfsnaam')}}" :error="$errors->first('editing.name')">
                                @if($editValues)
                                <x-inputs.text wire:model.defer="editing.name"></x-inputs.text>
                                @else
                                    {{$company->name}}
                                @endif
                            </x-inputs.group>
                        </div>

                        <div class="col-span-4 sm:col-span-2">
                            <x-inputs.group required for="email" inline="true" label="{{__('Email')}}" :error="$errors->first('editing.email')">
                                @if($editValues)
                                <x-inputs.text type="email" wire:model.defer="editing.email"></x-inputs.text>
                                @else
                                    {{$company->email}}
                                @endif
                            </x-inputs.group>
                        </div>

                        <div class="col-span-4 sm:col-span-2">
                            <x-inputs.group for="phone" inline="true" label="{{__('Telefoon')}}" :error="$errors->first('editing.phone')">
                                @if($editValues)
                                <x-inputs.text wire:model.defer="editing.phone"></x-inputs.text>
                                @else
                                    {{$company->phone}}
                                @endif
                            </x-inputs.group>
                        </div>

                        <div class="col-span-4 sm:col-span-2">
                            <x-inputs.group for="address" inline="true" label="{{__('Straat')}}" :error="$errors->first('editing.address')">
                                @if($editValues)
                                <x-inputs.text wire:model.defer="editing.address"></x-inputs.text>
                                @else
                                    {{$company->address}}
                                @endif
                            </x-inputs.group>
                        </div>

                        <div class="col-span-4 sm:col-span-1">
                            <x-inputs.group for="addon" inline="true" label="{{__('Extra')}}" :error="$errors->first('editing.addon')">
                                @if($editValues)
                                <x-inputs.text wire:model.defer="editing.addon"></x-inputs.text>
                                @else
                                    {{$company->addon}}
                                @endif
                            </x-inputs.group>
                        </div>

                        <div class="col-span-4 sm:col-span-1">
                            <x-inputs.group for="number" inline="true" label="{{__('Nummer')}}" :error="$errors->first('editing.number')">
                                @if($editValues)
                                <x-inputs.text wire:model.defer="editing.number"></x-inputs.text>
                                @else
                                    {{$company->number}}
                                @endif
                            </x-inputs.group>
                        </div>

                        <div class="col-span-4 sm:col-span-1">
                            <x-inputs.group for="zip_code" inline="true" label="{{__('Postcode')}}" :error="$errors->first('editing.zip_code')">
                                @if($editValues)
                                <x-inputs.text wire:model.defer="editing.zip_code"></x-inputs.text>
                                @else
                                    {{$company->zip_code}}
                                @endif
                            </x-inputs.group>
                        </div>

                        <div class="col-span-4 sm:col-span-1">
                            <x-inputs.group for="city" inline="true" label="{{__('Woonplaats')}}" :error="$errors->first('editing.city')">
                                @if($editValues)
                                <x-inputs.text wire:model.defer="editing.city"></x-inputs.text>
                                @else
                                    {{$company->city}}
                                @endif
                            </x-inputs.group>
                        </div>

                        <div class="col-span-4 sm:col-span-2">
                            <x-inputs.group for="country" inline="true" label="{{__('Land')}}" :error="$errors->first('editing.country')">
                                @if($editValues)
                                <x-inputs.text wire:model.defer="editing.country"></x-inputs.text>
                                @else
                                    {{$company->country}}
                                @endif
                            </x-inputs.group>
                        </div>

                        <div class="col-span-4 sm:col-span-1">
                            <x-inputs.group for="website" inline="true" label="{{__('Website')}}" :error="$errors->first('editing.website')">
                                @if($editValues)
                                <x-inputs.addon addontext="https://" wire:model.defer="editing.website"></x-inputs.addon>
                                @else
                                    <a href="https://{{$company->website}}">https://{{$company->website}}</a>
                                @endif
                            </x-inputs.group>
                        </div>

                        <div class="col-span-4 sm:col-span-1">
                            <x-inputs.group for="kvk" inline="true" label="{{__('KvK')}}" :error="$errors->first('editing.kvk')">
                                @if($editValues)
                                <x-inputs.text wire:model.defer="editing.kvk"></x-inputs.text>
                                @else
                                    {{$company->kvk}}
                                @endif
                            </x-inputs.group>
                        </div>

                        <div class="col-span-4 sm:col-span-2">
                            <x-inputs.group for="vat_number" inline="true" label="{{__('BTW Nummer')}}" :error="$errors->first('editing.vat_number')">
                                @if($editValues)
                                <x-inputs.text wire:model.defer="editing.vat_number"></x-inputs.text>
                                @else
                                    {{$company->vat_number}}
                                @endif
                            </x-inputs.group>
                        </div>

                        <div class="col-span-4 sm:col-span-4">
                            <x-inputs.group for="note" inline="true" label="{{__('Notitie')}}" :error="$errors->first('editing.note')">
                                @if($editValues)
                                <x-inputs.textarea wire:model.defer="editing.note"></x-inputs.textarea>
                                @else
                                    {{$company->note}}
                                @endif
                            </x-inputs.group>
                        </div>
                    </div>
                </div>
                <div class="px-4 py-3 bg-gray-50 text-right sm:px-6">
                    @if($editValues)
                    <x-button.secondary wire:click="$toggle('editValues')">{{__('Annuleren')}}</x-button.secondary>
                    <x-button.black type="submit">{{__('Opslaan')}}</x-button.black>
                    @endif
                </div>
            </div>
        </form>
    </section>
</div>
