<div class="max-w-full mx-auto px-4 sm:px-6 bg-white border-t border-gray-200 ">
    <div class="py-3">
        <nav class="flex" aria-label="Breadcrumb">
            <div class="flex sm:hidden">
                <a href="#" class="group inline-flex space-x-3 text-sm font-medium text-gray-500 hover:text-gray-700">
                    <!-- Heroicon name: solid/arrow-narrow-left -->
                    <svg class="flex-shrink-0 h-5 w-5 text-gray-400 group-hover:text-gray-600" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                        <path fill-rule="evenodd" d="M7.707 14.707a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l2.293 2.293a1 1 0 010 1.414z" clip-rule="evenodd" />
                    </svg>
                    <span>Back to Applicants</span>
                </a>
            </div>
            <div class="hidden sm:block">
                <ol role="list" class="flex items-center space-x-4">
                    <li>
                        <div>
                            <a href="{{route('dashboard')}}" class="text-gray-400 hover:text-gray-500">
                                <!-- Heroicon name: solid/home -->
                                <svg class="flex-shrink-0 h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                    <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z" />
                                </svg>
                                <span class="sr-only">Home</span>
                            </a>
                        </div>
                    </li>
                    @foreach(request()->breadcrumbs()->segments() as $segment)
                    <li>
                        <div class="flex items-center">
                            <svg class="flex-shrink-0 h-5 w-5 text-gray-300" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true">
                                <path d="M5.555 17.776l8-16 .894.448-8 16-.894-.448z" />
                            </svg>
                            <a href="{{$segment->url()}}" class="ml-4 text-sm font-medium text-gray-500 hover:text-gray-700">
                                {{$segment->name()}}

                            </a>
                        </div>
                    </li>
                    @endforeach
                </ol>
            </div>
        </nav>
    </div>
</div>
