<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="h-full bg-gray-100">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'UBOrtimo') }}</title>

    <!-- Fonts -->
    {{--        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap">--}}
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.3.1/css/all.css" integrity="sha384-mzrmE5qonljUremFsqc01SB46JvROS7bZs3IO2EmfFsd15uHvIt+Y8vEf7N7fWAU" crossorigin="anonymous">
    <link rel="stylesheet" href="https://rsms.me/inter/inter.css">
    <!-- Styles -->
    <!-- Alpine -->
    <link rel="stylesheet" href="{{ mix('css/app.css') }}">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@tailwindcss/ui@latest/dist/tailwind-ui.min.css">
    <script src="https://cdn.jsdelivr.net/gh/alpinejs/alpine@v2.x.x/dist/alpine.min.js" defer></script>
    @livewireStyles

    <!-- Scripts -->
{{--    <script src="{{ mix('js/app.js') }}" defer></script>--}}
    @yield('style')
</head>
<body class="h-full">
<div class="min-h-full">
    @livewire('navigation-menu', ['menuitems' => $menuitems])
    <x-header-bread-crumbs></x-header-bread-crumbs>
    <div class="py-1">

        @if (isset($header))
            <header>
                <div class="max-w-12xl mx-auto px-4 sm:px-6 lg:px-8">
                    <h1 class="font-bold leading-tight text-gray-900">
                        {{ $header }}
                    </h1>
                </div>
            </header>
        @endif
        <main>
            <div class="max-w-12xl mx-auto sm:px-6 lg:px-8">
                <!-- Replace with your content -->
            {{$slot}}
            <!-- /End replace -->
            </div>
        </main>

    </div>
</div>
<footer class="bg-white">
    <div class="max-w-12xl mx-auto py-1 px-4 sm:px-6 md:flex md:items-center md:justify-between lg:px-8">
        <div class="mt-8 md:mt-0 md:order-1">
            <p class="text-center text-base text-gray-400">
                &copy; {{date('Y')}} UBOrtimo. Software by Ortimo </p>
        </div>
    </div>
</footer>
<x-notification />
<x-notificationgreen />
<x-notificationerror />
@livewireScripts()
<script src="https://unpkg.com/flowbite@1.3.4/dist/flowbite.js"></script>
@yield('scripts')
</body>
</html>
