@props([
    'description' => '',
    'placeholder' => '',
    'type' => 'text',
])

<div>
    <div class="mt-1 relative rounded-md shadow-sm">
        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
            <!-- Heroicon name: solid/mail -->
            {{$slot}}
        </div>
        <input placeholder="{{$placeholder}}" {{ $attributes }} name="{{ $for ?? '' }}" type="{{$type}}" class="focus:ring-indigo-500 focus:border-indigo-500 block w-full pl-10 sm:text-sm border-gray-300 rounded-md">
        @if($description != '') <p class="text-gray-500">{{$description ?? ''}}</p> @endif
    </div>
</div>
