"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.dim = dim;
exports.default = void 0;
var _chalk = _interopRequireDefault(require("chalk"));
function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let alreadyShown = new Set();
function log(chalk, messages, key) {
    if (process.env.JEST_WORKER_ID !== undefined) return;
    if (key && alreadyShown.has(key)) return;
    if (key) alreadyShown.add(key);
    console.warn('');
    messages.forEach((message)=>console.warn(chalk, '-', message)
    );
}
function dim(input) {
    return _chalk.default.dim(input);
}
var _default = {
    info (key, messages) {
        log(_chalk.default.bold.cyan('info'), ...Array.isArray(key) ? [
            key
        ] : [
            messages,
            key
        ]);
    },
    warn (key, messages) {
        log(_chalk.default.bold.yellow('warn'), ...Array.isArray(key) ? [
            key
        ] : [
            messages,
            key
        ]);
    },
    risk (key, messages) {
        log(_chalk.default.bold.magenta('risk'), ...Array.isArray(key) ? [
            key
        ] : [
            messages,
            key
        ]);
    }
};
exports.default = _default;
