<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeExtraInformationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employee_extra_information', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id');
            $table->string('shoe_size')->nullable();
            $table->string('transport')->nullable()->comment('Private or company');
            $table->string('drivers_license')->nullable();
            $table->boolean('vog')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_extra_information');
    }
}
