<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeePersonalInformationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employee_personal_information', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->onDelete('cascade');
            $table->text('bsn')->nullable();
            $table->date('date_of_birth')->nullable();
            $table->string('birthplace')->nullable();
            $table->string('birthland')->nullable();
            $table->string('initials')->nullable();
            $table->string('salutation')->nullable()->comment('aanhef');
            $table->string('marital_status')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_personal_information');
    }
}
