<?php

namespace Database\Factories\Employees\Models;

use Employees\Models\EmployeeExtraInformation;
use Illuminate\Database\Eloquent\Factories\Factory;

class EmployeeExtraInformationFactory extends Factory
{
    protected $model = EmployeeExtraInformation::class;
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'shoe_size' => $this->faker->numberBetween(36, 46),
            'transport' => $this->faker->randomElement(['Prive', 'Bedrijf']),
            'drivers_license' => $this->faker->randomElement(['B', '']),
            'vog' => $this->faker->boolean,
        ];
    }
}
