<?php

namespace Database\Factories\Employees\Models;

use Employees\Models\EmployeeContactInformation;
use Illuminate\Database\Eloquent\Factories\Factory;

class EmployeeContactInformationFactory extends Factory
{
    protected $model = EmployeeContactInformation::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'address' => $this->faker->streetName(),
            'number' => $this->faker->numberBetween(1, 200),
            'addon' => $this->faker->streetSuffix(),
            'zip_code' => $this->faker->postcode(),
            'city' => $this->faker->city(),
            'country' => $this->faker->country(),
            'email' => $this->faker->email(),
            'phone' => $this->faker->e164PhoneNumber(),
            'phone_alternative' => $this->faker->e164PhoneNumber(),
        ];
    }
}
