<?php

namespace Database\Factories\Employees\Models;

use Employees\Models\EmployeeBankInformation;
use Illuminate\Database\Eloquent\Factories\Factory;

class EmployeeBankInformationFactory extends Factory
{
    protected $model = EmployeeBankInformation::class;
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'owner' => $this->faker->name(),
            'iban' => $this->faker->iban('nl'),
            'bic' => $this->faker->swiftBicNumber(),
            'valid_until' => $this->faker->creditCardExpirationDateString(true, 'Y-m-d'),
            'bank' => $this->faker->companySuffix(),
            'main_bank' => 0,
        ];
    }
}
