<?php

namespace Database\Factories\Companies\Models;

use Companies\Models\Company;
use Illuminate\Database\Eloquent\Factories\Factory;

class CompanyFactory extends Factory
{
    protected $model = Company::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->company(),
            'email' => $this->faker->safeEmail(),
            'address' => $this->faker->streetName,
            'number' => $this->faker->numberBetween(1, 400),
            'addon' => $this->faker->randomLetter,
            'zip_code' => $this->faker->postcode(),
            'city' => $this->faker->city(),
            'country' => $this->faker->country(),
            'phone' => $this->faker->e164PhoneNumber(),
            'note' => $this->faker->text(500),
            'website' => $this->faker->domainName(),
            'kvk' => $this->faker->randomNumber(7),
            'vat_number' => 'B01'.$this->faker->randomNumber(7),
        ];
    }
}
