<?php

namespace Database\Factories\Companies\Models;

use Companies\Models\CompanyContactPerson;
use Illuminate\Database\Eloquent\Factories\Factory;

class CompanyContactPersonFactory extends Factory
{
    protected $model = CompanyContactPerson::class;
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->name(),
            'company_function' => $this->faker->jobTitle(),
            'email' => $this->faker->safeEmail(),
            'phone' => $this->faker->phoneNumber(),
            'note' => $this->faker->text(30),
        ];
    }
}
