<?php

namespace App\Traits;

use Livewire\WithPagination;

trait HasPerPagePagination
{
    use WithPagination;

    public $perPage = 25;

    public function initializeHasPerPagePagination()
    {
        $this->perPage = session()->get('perPage', $this->perPage);
    }

    public function updatedPerPage($value)
    {
        session()->put('perPage', $value);
    }

    public function applyPagination($query)
    {
        return $query->paginate($this->perPage);
    }
}
