<?php

namespace App\Http\Livewire\Employees;

use Employees\Models\Employee;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Log;
use Livewire\Component;

// Actuele fase latenzien
// Aantal gewerkte weken
// Laatstst gewerkte dag
// indienstdatum
// Verloningsperiode

class EmployeeProfile extends Component
{
    public Employee $employee;
    public Employee $editing;

    public $showProfileModal = false;

    public $editInputValue = '';
    public $openeditInput = false;
    public $editInput = '';

    public function rules()
    {
        return [
            'editing.name' => 'required',
            'editing.surname' => 'required',
            'editing.personal_information.notes' => 'nullable',
            'editing.personal_information.date_of_birth' => 'nullable|date',
            'editing.contact_information.address' => 'required',
            'editing.contact_information.number' => 'required|numeric',
            'editing.contact_information.addon' => 'nullable',
            'editing.contact_information.zip_code' => 'required',
            'editing.contact_information.city' => 'required',
            'editing.contact_information.country' => 'required',
            'editing.contact_information.phone' => 'nullable|numeric',
            'editing.contact_information.phone_alternative' => 'nullable|numeric',
            'editing.contact_information.email' => 'nullable|email',
        ];
    }

    public function messages()
    {
        return [
            'editing.name.required' => __('Naam is verplicht'),
            'editing.surname.required' => __('Achternaam is verplicht'),
            'editing.contact_information.address.required' => __('Adres is verplicht'),
            'editing.personal_information.date_of_birth.date' => __('Geboortedatum moet een datum zijn'),
            'editing.contact_information.number.required' => __('Nummer is verplicht'),
            'editing.contact_information.number.numeric' => __('Nummer moet uit cijfers bestaan'),
            'editing.contact_information.zip_code.required' => __('Postcode is verplicht'),
            'editing.contact_information.city.required' => __('Woonplaats is verplicht'),
            'editing.contact_information.country.required' => __('Land is verplicht'),
            'editing.contact_information.phone.numeric' => __('Telefoon mag alleen maar uit cijfers bestaan'),
            'editing.contact_information.phone_alternative.numeric' => __('Telefoon alternatief mag alleen maar uit cijfers bestaan'),
            'editing.contact_information.email.email' => __('Email is niet geldig'),
        ];
    }


    public function mount(Employee $employee)
    {
        $this->employee = $employee;
        $this->editing = $employee;
    }

    public function edit()
    {
        $this->resetValidation();
        if ($this->editing->isNot($this->employee)) {
            $this->employee->load(['contact_information', 'personal_information']);
        }
        $this->showProfileModal = true;
    }

    public function saveProfile()
    {
        $this->validate();

        // remove the relationship attributes. If not removed it will cause an error because it wants to save the field contact_information etc.
        $this->editing->setRawAttributes(
            Arr::except($this->editing->getAttributes(), ['contact_information', 'personal_information'])
        );

        if ($this->editing->save()) {
            if($this->editing->contact_information->save()) {
                if ($this->editing->personal_information->save()) {
                    $this->notify(trans('Medewerker is bijgewerkt'));
                }
            }
        }
        $this->employee->refresh();
        $this->showProfileModal = false;
    }

    public function render()
    {
        return view('livewire.employees.employee-profile');
    }




    public function editValue($value, $id)
    {
        $this->editInput = $value;
        $this->editInputVAlue = $id;
        $this->openeditInput = true;
    }

    public function saveInputValue()
    {
        $this->employee->employed_date = $this->editInputVAlue;
        $this->employee->save();
        $this->openeditInput = false;
    }

    public function cancelInputValue()
    {

        $this->reset('editInputValue');
        $this->reset('editInput');
        $this->reset('openeditInput');
        Log::info($this->openeditInput);
        Log::info($this->editInput);
        Log::info($this->editInputVAlue);
    }
}
