<?php

namespace App\Http\Livewire\Employees;

use Employees\Models\Employee;
use Employees\Models\EmployeeExtraInformation;
use Employees\Models\EmployeePersonalInformation;
use Livewire\Component;

class EmployeeBasicInfo extends Component
{
    public EmployeePersonalInformation $basicinfo;
    public EmployeeExtraInformation $extrainfo;
    public EmployeePersonalInformation $basicinfoediting;
    public EmployeeExtraInformation $extrainfoediting;

    public $showBasicInfoModal = false;
    public $showBsn = false;

    public function rules()
    {
        return [
            'basicinfoediting.bsn' => 'nullable|numeric',
            'basicinfoediting.birthplace' => 'nullable',
            'basicinfoediting.birthland' => 'nullable',
            'basicinfoediting.initials' => 'nullable',
            'basicinfoediting.salutation' => 'nullable',
            'basicinfoediting.marital_status' => 'nullable',
            'extrainfoediting.shoe_size' => 'nullable|numeric',
            'extrainfoediting.transport' => 'nullable',
            'extrainfoediting.drivers_license' => 'nullable',
            'extrainfoediting.vog' => 'nullable',
        ];
    }

    public function messages()
    {
        return [
            'basicinfoediting.bsn.numeric' => __('BSN mag alleen uit cijfers bestaan'),
            'extrainfoediting.shoe_size.numeric' => __('Schoenmaat mag alleen uit cijfers bestaan'),
        ];
    }

    public function mount(Employee $employee)
    {
        $this->basicinfo = $employee->personal_information;
        $this->extrainfo = $employee->extra_information;
        $this->basicinfoediting = $employee->personal_information;
        $this->extrainfoediting = $employee->extra_information;
    }

    public function edit()
    {
        $this->resetValidation();
        if ($this->basicinfoediting->isNot($this->basicinfo)) {
            $this->basicinfoediting = $this->basicinfo;
        }
        if ($this->extrainfoediting->isNot($this->extrainfo)) {
            $this->extrainfoediting = $this->extrainfo;
        }
        $this->showBasicInfoModal = true;
    }

    public function saveBasicInfo()
    {
        $this->validate();

        if ($this->basicinfoediting->save()) {
            if ($this->extrainfoediting->save()) {
                $this->notify(trans('Medewerker is bijgewerkt'));
            }
        }
        $this->basicinfo->refresh();
        $this->extrainfo->refresh();
        $this->showBasicInfoModal = false;
    }

    public function render()
    {
        return view('livewire.employees.employee-basic-info');
    }
}
