<?php

namespace App\Http\Livewire\Employees;

use App\Rules\BicRule;
use App\Rules\IbanRule;
use Employees\Models\Employee;
use Employees\Models\EmployeeBankInformation;
use Livewire\Component;

class EmployeeBank extends Component
{
    public $showEditBankModal = false;
    public $showDeleteModal = false;
    public $showBankNumbers = false;
    public $employee;
    public EmployeeBankInformation $editing;
    public $toBeDeletedBank;

    public function rules()
    {
        return [
            'editing.iban' => ['required', new IbanRule()],
            'editing.bic' => ['required', new BicRule()],
            'editing.owner' => 'required',
            'editing.bank' => 'required',
            'editing.valid_until' => 'nullable',
        ];
    }

    public function messages()
    {
        return [
            'editing.iban.required' => __('IBAN is verplicht'),
            'editing.bic.required' => __('BIC is verplicht'),
            'editing.owner.required' => __('Eignaar naam is verplicht'),
            'editing.bank.required' => __('Naam van bank is verplicht'),
            'editing.valid_until.required' => __('Geldig tot is verplicht'),
        ];
    }

    public function mount(Employee $employee)
    {
        $this->employee = $employee;
        $this->editing = $this->makeBlankEmployeeBank();
    }

    public function makeBlankEmployeeBank()
    {
        return new EmployeeBankInformation();
    }

    public function render()
    {
        return view('livewire.employees.employee-bank');
    }

    public function addBank()
    {
        $this->resetValidation();
        if ($this->editing->getKey()) {
            $this->editing = $this->makeBlankEmployeeBank();
        }
        $this->showEditBankModal = true;
    }

    public function edit(EmployeeBankInformation $employeeBankInformation)
    {
        $this->resetValidation();
        if ($this->editing->isNot($employeeBankInformation)) {
            $this->editing = $employeeBankInformation;
        }
        $this->showEditBankModal = true;
    }

    public function saveBank()
    {
        $this->validate();
        $this->editing->employee_id = $this->employee->id;
        $this->editing->main_bank = 1;
        $this->editing->iban = strtoupper($this->editing->iban);
        $this->editing->bic = strtoupper($this->editing->bic);
        if ($this->editing->save()) {
            EmployeeBankInformation::where('employee_id', $this->employee->id)->where('id', '!=', $this->editing->id)->update(['main_bank' => 0]);
            $this->notify(trans('Bank van medewerker is opgslagen'));
            $this->employee->refresh();
        }
        $this->showEditBankModal = false;
    }

    public function showDeleteBankModalMethod($bank)
    {

        $this->toBeDeletedBank = $bank;
        $this->showDeleteModal = true;
    }

    public function changeMainBank($bankid)
    {

        if (EmployeeBankInformation::find($bankid)->update(['main_bank' => 1])) {
            EmployeeBankInformation::where('employee_id', $this->employee->id)->where('id', '!=', $bankid)->update(['main_bank' => 0]);
            $this->employee->refresh();
//            activity()->performedOn(EmployeeBankInformation::find($bankid))->log('De hoofdbank is gewijzigd');
            $this->notify(trans('Hoofdbank van medewerker is gewijzigd'));
        }
    }

    public function deleteBank()
    {
        $bank = EmployeeBankInformation::find($this->toBeDeletedBank['id']);
        if ($bank->delete()) {
            $this->notify(trans('Bank van medewerker is verwijderd'));
            $this->showDeleteModal = false;
            $this->employee->refresh();
        } else {
            $this->notifyerror(trans('Er is iets mis gegaan.'));
        }
    }
}
