<?php

namespace App\Http\Livewire\Companies;

use Companies\Models\Company;
use Companies\Models\CompanyContactPerson;
use Livewire\Component;
use function view;

class CompanyContactPersonLiveWire extends Component
{
    public Company $company;
    public $showEditContactPersonModal = false;
    public $showDeleteModal = false;
    public CompanyContactPerson $editing;
    public $toBeDeletedContactPerson;

    public function rules()
    {
        return [
            'editing.name' => 'required',
            'editing.company_function' => 'required',
            'editing.email' => 'required|email',
            'editing.phone' => 'required|numeric',
            'editing.note' => 'nullable|max:500',
        ];
    }

    public function messages()
    {
        return [
            'editing.name.required' => __('Naam is verplicht'),
            'editing.company_function.required' => __('Functie is verplicht'),
            'editing.email.required' => __('Email is verplicht'),
            'editing.email.email' => __('Email is niet geldig'),
            'editing.phone.required' => __('Telefoon is verplicht'),
            'editing.phone.numeric' => __('Telefoon is moet alleen uit cijfers bestaan'),
            'editing.note.max' => __('Notitie is te lang (max 500)'),
        ];
    }

    public function mount(Company $company)
    {
        $this->company = $company;
        $this->editing = $this->makeBlankCompanyContactPerson();
    }

    public function makeBlankCompanyContactPerson()
    {
        return new CompanyContactPerson();
    }

    public function addContactPerson()
    {
        $this->resetValidation();
        if ($this->editing->getKey()) {
            $this->editing = $this->makeBlankCompanyContactPerson();
        }
        $this->showEditContactPersonModal = true;
    }

    public function edit(CompanyContactPerson $companyContactPerson)
    {
        $this->resetValidation();
        if ($this->editing->isNot($companyContactPerson)) {
            $this->editing = $companyContactPerson;
        }
        $this->showEditContactPersonModal = true;
    }

    public function saveContactPerson()
    {
        $this->validate();
        $this->editing->company_id = $this->company->id;
        if ($this->editing->save()) {
            $this->notify(trans('Contactpersoon is opgslagen'));
            $this->company->refresh();
        }
        $this->showEditContactPersonModal = false;
    }

    public function showDeleteContactPersonModalMethod($bank)
    {
        $this->toBeDeletedContactPerson = $bank;
        $this->showDeleteModal = true;
    }

    public function deleteContactPerson()
    {
        $bank = CompanyContactPerson::find($this->toBeDeletedContactPerson['id']);
        if ($bank->delete()) {
            $this->notify(trans('Contactpersoon is verwijderd'));
            $this->showDeleteModal = false;
            $this->company->refresh();
        } else {
            $this->notifyerror(trans('Er is iets mis gegaan.'));
        }
    }

    public function render()
    {
        return view('livewire.companies.company-contact-person');
    }
}
