<?php

namespace App\Http\Livewire;

use Illuminate\Support\Facades\Artisan;
use Livewire\Component;

class ArtisanCommands extends Component
{
    public $loading = false;

    public function databaseMigrate()
    {
        $this->loading = true;
        $this->artisanCommand('migrate');
        $this->loading = false;
        $this->notify(Artisan::output());
    }

    public function databaseMigrateFreshSeed()
    {
        $this->loading = true;
        $this->artisanCommand('migrate:fresh --seed');
        $this->loading = false;
        return redirect(request()->header('Referer'));
    }

    public function databaseMigrateFresh()
    {
        $this->loading = true;
        $this->artisanCommand('migrate:fresh');
        $this->loading = false;
        return redirect(request()->header('Referer'));
    }

    public function databaseSeed()
    {
        $this->loading = true;
        $this->artisanCommand('db:seed');
        $this->loading = false;
    }

    public function databaseMigrateSeed()
    {
        $this->loading = true;
    }

    public function cacheClear()
    {
        $this->loading = true;
        $this->artisanCommand('cache:clear');
        $this->loading = false;
    }

    public function optimizeClear()
    {
        $this->loading = true;
        $this->artisanCommand('optimize:clear');
        $this->loading = false;
    }

    public function optimize()
    {
        $this->loading = true;
        $this->artisanCommand('optimize');
        $this->loading = false;
    }

    public function artisanCommand($command)
    {
        Artisan::call($command);
        dd(Artisan::output());
    }

    public function render()
    {
        return view('livewire.artisan-commands')->layout('layouts.guest');
    }
}
