<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;

class ArtisanCommandsController extends Controller
{
    public function index()
    {
        return view('artisan-commands');
    }
    public function databaseMigrate()
    {
        try {
            Artisan::call('migrate');
            dd(Artisan::output());
        } catch (\Throwable $exception) {
            dd($exception);
        }
    }

    public function databaseMigrateFreshSeed()
    {
        $this->artisanCommand('migrate:fresh --seed');
    }

    public function databaseMigrateFresh()
    {
        $this->artisanCommand('migrate:fresh');
    }

    public function databaseSeed()
    {
        $this->artisanCommand('db:seed');
    }

    public function databaseMigrateSeed()
    {
        $this->artisanCommand('migrate --seed');
    }

    public function cacheClear()
    {
        $this->artisanCommand('cache:clear');
    }

    public function optimizeClear()
    {
        $this->artisanCommand('optimize:clear');
    }

    public function optimize()
    {
        $this->artisanCommand('optimize');
    }

    public function artisanCommand($command)
    {
        try {
            Artisan::call($command);
            dd(Artisan::output());
        } catch (\Throwable $exception) {
            dd($exception);
        }
    }
}
