<?php

namespace Companies\Models;

use App\Traits\ModifyLogCauser;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;

class Company extends Model
{
    use HasFactory, SoftDeletes, LogsActivity, ModifyLogCauser;

    public function contact_person()
    {
        return $this->hasMany(CompanyContactPerson::class);
    }

    public function getActiveColorAttribute()
    {
        return [
            '1' => 'green',
            '0' => 'red'
        ][$this->active];
    }
}
