<?php

namespace Tests\Feature;

use App\Http\Livewire\EmployeesTable;
use App\Models\User;
use Employees\Models\Employee;
use Employees\Models\EmployeeBankInformation;
use Employees\Models\EmployeeContactInformation;
use Employees\Models\EmployeePersonalInformation;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Livewire\Livewire;
use Tests\TestCase;

class EmployeeTest extends TestCase
{
    use RefreshDatabase;
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function test_create_user()
    {
        $user = User::factory()->create();
        $this->actingAs($user);
        Livewire::test(EmployeesTable::class)
            ->set('editing.name', 'Mark')
            ->set('editing.surname', 'Acting')
            ->set('editing.active', '1')
            ->set('editing.contact_information.address', 'Streetname')
            ->set('editing.contact_information.number', '1')
            ->set('editing.contact_information.addon', 'a')
            ->set('editing.contact_information.zip_code', '5568LL')
            ->set('editing.contact_information.city', 'Eindhoven')
            ->set('editing.contact_information.country', 'Nederland')
            ->call('save');
    }

    public function test_edit_user()
    {
        $user = User::factory()->create();
        $employee = Employee::factory()->create();
        EmployeeContactInformation::factory()->make(
            ['employee_id' => $employee->id]
        );
        EmployeeBankInformation::factory()->make(
            ['employee_id' => $employee->id]
        );
        EmployeePersonalInformation::factory()->make(
            ['employee_id' => $employee->id]
        );
        $this->actingAs($user);
        Livewire::test(EmployeesTable::class)
            ->call('edit', $employee)
            ->call('save');
    }
}
