<nav x-data="{ open: false }" class="bg-white shadow-sm">
    <div class="max-w-12xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-10">
            <div class="flex">
                <div class="flex-shrink-0 flex items-center">
                    <img class="block lg:hidden pt-1 h-6 w-auto" src="{{asset('img/logo.png')}}" alt="UBOrtimo">
                    <img class="hidden lg:block pt-1 h-6 w-auto" src="{{asset('img/logo.png')}}" alt="UBOrtimo">
                </div>
                <div class="hidden sm:-my-px sm:ml-6 sm:flex sm:space-x-8">
                    @foreach($menuitems as $menuitem)
                        <!-- Current: "border-indigo-500 text-gray-900", Default: "border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300" -->
                            <div @if(!empty($menuitem['children'])) x-data="{openmenu: false}" @endif class="relative pt-3 {{request()->is($menuitem['active'].'*') ? 'border-indigo-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'}} items-center px-1 border-b-2 text-sm font-medium">
                                <a @if(empty($menuitem['children'])) href="{{route($menuitem['routename'])}}" @endif x-on:click.away="openmenu = false" @click=" openmenu = ! openmenu" class="cursor-pointer" >
                                    {{$menuitem['name']}}
                                </a>
                                @if(!empty($menuitem['children']))
                                    <div x-show="openmenu" style="display: none; top: 30px;"
                                         x-transition:enter="transition ease-out duration-200"
                                         x-transition:enter-start="opacity-0 translate-y-1"
                                         x-transition:enter-end="opacity-100 translate-y-0"
                                         x-transition:leave="transition ease-in duration-150"
                                         x-transition:leave-start="opacity-100 translate-y-0"
                                         x-transition:leave-end="opacity-0 translate-y-1"
                                         class=" transform transition-all absolute z-10 left-1/2 transform -translate-x-1/2 mt-3 px-2 w-screen max-w-xs sm:px-0">
                                    <div class="rounded-lg shadow-lg ring-1 ring-black ring-opacity-5 overflow-hidden">
                                        <div class="relative grid gap-6 bg-white px-5 py-6 sm:gap-8 sm:p-8">
                                            @foreach($menuitem['children'] as $childmenuitem)
                                            <a href="{{route($childmenuitem['routename'])}}" class="-m-3 p-3 block rounded-md hover:bg-gray-50 transition ease-in-out duration-150">
                                                <p class="text-base font-medium text-gray-900">
                                                    {{$childmenuitem['name']}}
                                                </p>
                                                <p class="mt-1 text-sm text-gray-500">
                                                    {{$childmenuitem['uitleg']}}
                                                </p>
                                            </a>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                                @endif
                            </div>

                    @endforeach
                </div>
            </div>

{{--            <div class="flex-1 flex items-center justify-center px-2 lg:ml-6 lg:justify-end">--}}
{{--                <div class="max-w-lg w-full lg:max-w-xs">--}}
{{--                    <label for="search" class="sr-only">Search</label>--}}
{{--                    <div class="relative">--}}
{{--                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">--}}
{{--                            <!-- Heroicon name: solid/search -->--}}
{{--                            <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">--}}
{{--                                <path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z" clip-rule="evenodd" />--}}
{{--                            </svg>--}}
{{--                        </div>--}}
{{--                        <input id="search" name="search" class="block w-full pl-10 pr-3 py-2 border border-gray-300 rounded-md leading-5 bg-white shadow-sm placeholder-gray-500 focus:outline-none focus:placeholder-gray-400 focus:ring-1 focus:ring-blue-600 focus:border-blue-600 sm:text-sm" placeholder="{{__('Zoeken')}}" type="search">--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
            <div class="hidden sm:ml-6 sm:flex sm:items-center" x-data="{ profilemenu: false}">
                <!-- Profile dropdown -->
                <div class="ml-3 relative" >
                    <div>
                        <button x-on:click.away="profilemenu = false" @click=" profilemenu = ! profilemenu" type="button" class="bg-white flex text-sm focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" id="user-menu-button" aria-expanded="false" aria-haspopup="true">
                        {{ Auth::user()->name }}
                            <svg class="ml-2 -mr-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                    </div>

                    <!--
                      Dropdown menu, show/hide based on menu state.

                      Entering: "transition ease-out duration-200"
                        From: "transform opacity-0 scale-95"
                        To: "transform opacity-100 scale-100"
                      Leaving: "transition ease-in duration-75"
                        From: "transform opacity-100 scale-100"
                        To: "transform opacity-0 scale-95"
                    -->
                    <div x-show="profilemenu" style="display: none;" :class="{'transform opacity-100 scale-100 transition ease-out duration-800 block': profilemenu, 'transform opacity-0 scale-95 transition ease-in duration-75 hidden': ! profilemenu}" class="origin-top-right absolute right-0 mt-2 w-48 rounded-md shadow-lg py-1 bg-white ring-1 ring-black ring-opacity-5 focus:outline-none" role="menu" aria-orientation="vertical" aria-labelledby="user-menu-button" tabindex="-1">
                        <!-- Active: "bg-gray-100", Not Active: "" -->
                        <x-dropdown-link href="{{ route('profile.show') }}">
                            {{ __('Profile') }}
                        </x-dropdown-link>

                        <div class="border-t border-gray-100"></div>
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf

                            <x-dropdown-link href="{{ route('logout') }}"
                                                 onclick="event.preventDefault();
                                                this.closest('form').submit();">
                                {{ __('Log Out') }}
                            </x-dropdown-link>
                        </form>
                    </div>
                </div>
            </div>
            <div class="-mr-2 flex items-center sm:hidden">
                <!-- Mobile menu button -->
                <button type="button" @click="open = ! open"  class="bg-white inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" aria-controls="mobile-menu" aria-expanded="false">
                    <span class="sr-only">Open main menu</span>
                    <!--
                      Heroicon name: outline/menu

                      Menu open: "hidden", Menu closed: "block"
                    -->
                    <svg class="block h-6 w-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                    </svg>
                    <!--
                      Heroicon name: outline/x

                      Menu open: "block", Menu closed: "hidden"
                    -->
                    <svg class="hidden h-6 w-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>
{{--    <div class="max-w-12xl mx-auto px-4 sm:px-6">--}}
{{--        <div class="border-t border-gray-200 py-3">--}}
{{--            <nav class="flex" aria-label="Breadcrumb">--}}
{{--                <div class="hidden sm:block">--}}
{{--                    <ol role="list" class="flex items-center space-x-4">--}}
{{--                        <li>--}}
{{--                            <div>--}}
{{--                                <a href="#" class="text-gray-400 hover:text-gray-500">--}}
{{--                                    <!-- Heroicon name: solid/home -->--}}
{{--                                    <svg class="flex-shrink-0 h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">--}}
{{--                                        <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"/>--}}
{{--                                    </svg>--}}
{{--                                    <span class="sr-only">Home</span>--}}
{{--                                </a>--}}
{{--                            </div>--}}
{{--                        </li>--}}

{{--                        <li>--}}
{{--                            <div class="flex items-center">--}}
{{--                                <svg class="flex-shrink-0 h-5 w-5 text-gray-300" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true">--}}
{{--                                    <path d="M5.555 17.776l8-16 .894.448-8 16-.894-.448z"/>--}}
{{--                                </svg>--}}
{{--                                <a href="#" class="ml-4 text-sm font-medium text-gray-500 hover:text-gray-700">Jobs</a>--}}
{{--                            </div>--}}
{{--                        </li>--}}

{{--                        <li>--}}
{{--                            <div class="flex items-center">--}}
{{--                                <svg class="flex-shrink-0 h-5 w-5 text-gray-300" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true">--}}
{{--                                    <path d="M5.555 17.776l8-16 .894.448-8 16-.894-.448z"/>--}}
{{--                                </svg>--}}
{{--                                <a href="#" class="ml-4 text-sm font-medium text-gray-500 hover:text-gray-700">Front--}}
{{--                                    End Developer</a>--}}
{{--                            </div>--}}
{{--                        </li>--}}

{{--                        <li>--}}
{{--                            <div class="flex items-center">--}}
{{--                                <svg class="flex-shrink-0 h-5 w-5 text-gray-300" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true">--}}
{{--                                    <path d="M5.555 17.776l8-16 .894.448-8 16-.894-.448z"/>--}}
{{--                                </svg>--}}
{{--                                <a href="#" class="ml-4 text-sm font-medium text-gray-500 hover:text-gray-700" aria-current="page">Applicants</a>--}}
{{--                            </div>--}}
{{--                        </li>--}}
{{--                    </ol>--}}
{{--                </div>--}}
{{--            </nav>--}}
{{--        </div>--}}
{{--    </div>--}}
    <!-- Mobile menu, show/hide based on menu state. -->
    <div :class="{'block': open, 'hidden': ! open}" class="sm:hidden" id="mobile-menu">
        <div class="pt-2 pb-3 space-y-1">
            <!-- Current: "bg-indigo-50 border-indigo-500 text-indigo-700", Default: "border-transparent text-gray-600 hover:bg-gray-50 hover:border-gray-300 hover:text-gray-800" -->
            @foreach($menuitems as $menuitem)
                <a href="{{route($menuitem['routename'])}}" class="{{request()->is($menuitem['active'].'*') ? 'bg-indigo-50 border-indigo-500 text-indigo-700' : 'border-transparent text-gray-600 hover:bg-gray-50 hover:border-gray-300 hover:text-gray-800'}} block pl-3 pr-4 py-2 border-l-4 text-base font-medium" aria-current="page">{{$menuitem['name']}}</a>
            @endforeach
        </div>
        <div class="pt-4 pb-3 border-t border-gray-200">
            <div class="flex items-center px-4">
                <div class="flex-shrink-0">
                    <img class="h-10 w-10 rounded-full" src="https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=facearea&facepad=2&w=256&h=256&q=80" alt="">
                </div>
                <div class="ml-3">
                    <div class="text-base font-medium text-gray-800">Tom Cook</div>
                    <div class="text-sm font-medium text-gray-500">tom@example.com</div>
                </div>
                <button type="button" class="ml-auto bg-white flex-shrink-0 p-1 rounded-full text-gray-400 hover:text-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    <span class="sr-only">View notifications</span>
                    <!-- Heroicon name: outline/bell -->
                    <svg class="h-6 w-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                    </svg>
                </button>
            </div>
            <div class="mt-3 space-y-1">
                <a href="#" class="block px-4 py-2 text-base font-medium text-gray-500 hover:text-gray-800 hover:bg-gray-100">Your Profile</a>

                <a href="#" class="block px-4 py-2 text-base font-medium text-gray-500 hover:text-gray-800 hover:bg-gray-100">Settings</a>

                <a href="#" class="block px-4 py-2 text-base font-medium text-gray-500 hover:text-gray-800 hover:bg-gray-100">Sign out</a>
            </div>
        </div>
    </div>
</nav>

