<div>
    @section('style')
        <style>
            [type='checkbox']:focus, [type='radio']:focus {
                outline: none !important;
            }

            input:focus, select:focus, textarea:focus, button:focus {
                outline: none !important;
            }
        </style>
    @endsection
    <div class="py-1 space-y-4">
        <div class="flex justify-between">
            <!-- Geavanceerd zoeken -->
            <div class="w-2/4 flex space-x-4">
                <div class="flex-initial w-64">
                    <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <!-- Heroicon name: solid/search -->
                        <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                            <path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <x-inputs.text type="search" class="pl-10" wire:model.debounce.500ms="filters.search" placeholder="{{__('Zoeken')}}"></x-inputs.text>
                    </div>

                </div>
                <x-button.link wire:click="toggleShowFilters">@if(!$showFilters) {{__('Geavanceerd zoeken')}}
                    ...@else {{__('Sluit geavanceerd zoeken')}}@endif</x-button.link>
            </div>
            <!-- Handelingen -->
            <div class="space-x-2 w-4/4 flex items-center">
                <x-inputs.group borderless paddingless for="perPage" label="Per Pagina">
                    <x-inputs.select wire:model="perPage" id="perPage">
                        <option value="10">10</option>
                        <option value="25">25</option>
                        <option value="50">50</option>
                        <option value="100">100</option>
                    </x-inputs.select>
                </x-inputs.group>
                <x-dropdown label="{{__('Bulkacties')}}">
                    <x-dropdown.item wire:click="exportSelected" type="button" class="flex items-center space-x-2">
                        <x-icon.download class="text-cool-gray-400"/>
                        <span>{{__('Export')}}</span>
                    </x-dropdown.item>
                    <x-dropdown.item wire:click="$toggle('showDeleteModal')" type="button" class="flex items-center space-x-2">
                        <x-icon.trash class="text-cool-gray-400"/>
                        <span>{{__('Verwijderen')}}</span>
                    </x-dropdown.item>
                </x-dropdown>
                <x-button.primary wire:click="create">
                    <x-icon.plus/>{{__('Medewerker Toevoegen')}}
                </x-button.primary>
            </div>
        </div>
    </div>

    <div>
        <div wire:model.defer="showFilters" x-data="{ shown: @entangle('showFilters')}">
            <div style="display: none;" class="transform transition-all bg-cool-gray-200 p-4 rounded shadow-inner flex relative" x-show="shown">
                <div class="w-1/2 pr-2 space-y-4">
                    <x-inputs.group inline for="filter-active" label="Active">
                        <x-inputs.select id="filter-active" wire:model="filters.active">
                            <option value="" disabled>-- {{__('Selecteer status')}} --</option>
                            <option value="1">{{__('Active')}}</option>
                            <option value="'0'">{{__('Inactive')}}</option>
                        </x-inputs.select>
                    </x-inputs.group>
                    <x-button.link class="absolute right-0 bottom-0 p-4" wire:click="resetFilters">{{__('Reset filters')}}</x-button.link>
                </div>
            </div>
        </div>
    </div>

    <div class="max-w-8xl mx-auto sm:px-0 lg:px-0">
        <!-- This example requires Tailwind CSS v2.0+ -->
        <div class="flex flex-col">
            <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                <div class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8">
                    <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg my-2">
                        <x-table.table>
                            <x-slot name="head">
                                <x-table.heading class="pr-0 w-8">
                                    <x-inputs.checkbox wire:model="selectPage"/>
                                </x-table.heading>
                                <x-table.heading sortable multi-column wire:click="sortBy('name')" :direction="$sorts['name'] ?? null">
                                    Naam
                                </x-table.heading>
                                <x-table.heading sortable multi-column wire:click="sortBy('contact_information.address')" :direction="$sorts['contact_information.address'] ?? null">
                                    Adres
                                </x-table.heading>
                                <x-table.heading sortable multi-column wire:click="sortBy('contact_information.city')" :direction="$sorts['contact_information.city'] ?? null">
                                    City
                                </x-table.heading>
                                <x-table.heading sortable multi-column wire:click="sortBy('contact_information.country')" :direction="$sorts['contact_information.country'] ?? null">
                                    Country
                                </x-table.heading>
                                <x-table.heading class="text-left">
                                    Actief
                                </x-table.heading>
                                <x-table.heading></x-table.heading>
                            </x-slot>
                            <x-slot name="body">
                                @if($selectPage)
                                    <x-table.row class="bg-cool-gray-200" wire:key="row-message">
                                        <x-table.cell colspan="9">

                                            @unless($selectAll)
                                                <div>
                                                    <span>{!! __('U heeft <b>:count</b> medewerkers geselecteerd, Wilt u alle <b>:total</b> selecteren?', ['count' => $employees->count(), 'total' => $employees->total()]) !!}</span>
                                                    <x-button.link wire:click="selectAll" class="ml-1" textcolor="text-blue-500">{{__('Alles Selecteren')}}</x-button.link>
                                                </div>
                                            @else
                                                <span>{!! __('U heeft alle <b>:total</b> medewerkers geselecteerd', ['total' => $employees->total()]) !!}</span>
                                            @endif
                                        </x-table.cell>
                                    </x-table.row>
                                @endif
                                @forelse($employees as $employee)
                                    <x-table.row wire:loading.delay.class="opacity-50" wire:key="row-{{$employee->id}}">
                                        <x-table.cell>
                                            <x-inputs.checkbox wire:model="selected" value="{{$employee->id}}"></x-inputs.checkbox>
                                        </x-table.cell>
                                        <x-table.cell>
                                            <div class="flex">
                                                <a href="{{route('employee.show', $employee->id)}}" class="group inline-flex space-x-2 truncate text-sm">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="flex-shrink-0 h-5 w-5 text-gray-400 group-hover:text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.121 17.804A13.937 13.937 0 0112 16c2.5 0 4.847.655 6.879 1.804M15 10a3 3 0 11-6 0 3 3 0 016 0zm6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                                    </svg>
                                                    <p class="text-gray-900 truncate group-hover:text-gray-900">
                                                        {{$employee->name}} {{$employee->surname}}
                                                    </p>
                                                </a>
                                            </div>
                                        </x-table.cell>
                                        <x-table.cell>
                                            <p class="text-gray-500">{{$employee->contact_information->address}} {{$employee->contact_information->addon}} {{$employee->contact_information->number}}</p>
                                        </x-table.cell>
                                        <x-table.cell>
                                            <p class="text-gray-500">{{$employee->contact_information->city}}</p>
                                        </x-table.cell>
                                        <x-table.cell>
                                            <p class="text-gray-500">{{$employee->contact_information->country}}</p>
                                        </x-table.cell>
                                        <x-table.cell>
                                            <x-button.link underline wire:click="changeStatus({{$employee}})">
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-{{ $employee->active_color }}-100 text-{{ $employee->active_color }}-800 capitalize">
                                                @if($employee->active) Actief @else Inactief @endif
                                            </span>
                                            </x-button.link>
                                        </x-table.cell>
                                        <x-table.cell>
                                            <x-button.link textcolor="text-blue-500" wire:click="edit({{$employee}})">{{__('Bewerken')}}</x-button.link>
                                        </x-table.cell>
                                    </x-table.row>
                                @empty
                                    <x-table.row>
                                        <x-table.cell colspan="7">
                                            <div class="flex justify-center items-center">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="inline-block text-cool-gray-300 mx-2 h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.121 17.804A13.937 13.937 0 0112 16c2.5 0 4.847.655 6.879 1.804M15 10a3 3 0 11-6 0 3 3 0 016 0zm6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                                </svg>
                                                <span class="text-xl text-cool-gray-400 py-8 font-medium">{{__('Geen werknemer gevonden...')}}</span>
                                            </div>
                                        </x-table.cell>
                                    </x-table.row>
                                @endforelse
                            </x-slot>
                        </x-table.table>
                    </div>
                    <div>
                        {{$employees->links()}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Confirm modal -->
    <form wire:submit.prevent="deleteSelected">
        <x-modal.confirmation wire:model.defer="showDeleteModal">
            <x-slot name="title">{{__('Medewerker(s) verwijderen')}}</x-slot>
            <x-slot name="content">{{__('Deze actie kan niet ongedaan worden gemaakt. Alle informatie met betrekking tot deze medewerker zal worden verwijderd. U kunt ook uw medewerker op inactief stellen.')}}</x-slot>
            <x-slot name="footer">
                <x-button.danger type="submit">{{__('Verwijderen')}}</x-button.danger>
                <x-button.secondary wire:click="$set('showDeleteModal', false)">{{__('Annuleren')}}</x-button.secondary>
            </x-slot>
        </x-modal.confirmation>
    </form>
    <!-- Bewerken en toevoegen modal -->
    <form wire:submit.prevent="save">
        <x-modal.dialog wire:model.defer="showEditModal" maxWidth="7xl">
            <x-slot name="title">{{__('Medewerker bewerken')}}</x-slot>
            <x-slot name="content">


                <div class="mt-10 sm:mt-0">
                    <div class="md:grid md:grid-cols-3 md:gap-6">
                        <div class="md:col-span-1">
                            <div class="px-4 sm:px-0">
                                <h3 class="text-lg font-medium leading-6 text-gray-900">{{__('Persoonlijke informatie')}}</h3>
                                <p class="mt-1 text-sm text-gray-600">
                                    {{__('Alle persoonlijke informatie van de werknemer')}}
                                </p>
                            </div>
                        </div>
                        <div class="mt-5 md:mt-0 md:col-span-2">
                            <div class="grid grid-cols-6 gap-6">
                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="name" inline="true" label="{{__('Naam')}}" :error="$errors->first('editing.name')">
                                        <x-inputs.text wire:model.defer="editing.name"></x-inputs.text>
                                    </x-inputs.group>
                                </div>

                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="surname" inline="true" label="{{__('Achternaam')}}" :error="$errors->first('editing.surname')">
                                        <x-inputs.text wire:model.defer="editing.surname"></x-inputs.text>
                                    </x-inputs.group>
                                </div>

                                <div class="col-span-6 sm:col-span-4">
                                    <x-inputs.group for="Actief" inline="true" label="{{__('Achternaam')}}" :error="$errors->first('editing.active')">
                                        <x-inputs.checkbox for="Actief" wire:model.defer="editing.active" description="Bij inactief zal de medewerker nergens anders verschijnen"></x-inputs.checkbox>
                                    </x-inputs.group>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr class="my-8">
                    <div class="md:grid md:grid-cols-3 md:gap-6">
                        <div class="md:col-span-1">
                            <div class="px-4 sm:px-0">
                                <h3 class="text-lg font-medium leading-6 text-gray-900">{{__('Contact gegevens')}}</h3>
                                <p class="mt-1 text-sm text-gray-600">
                                    {{__('Alle contact gegevens van de werknemer')}}
                                </p>
                            </div>
                        </div>
                        <div class="mt-5 md:mt-0 md:col-span-2">
                            <div class="grid grid-cols-9 gap-9 my-3">
                                <div class="col-span-5 sm:col-span-5">
                                    <x-inputs.group for="address" inline="true" label="{{__('Straat')}}" :error="$errors->first('editing.contact_information.address')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.address"></x-inputs.text>
                                    </x-inputs.group>
                                </div>

                                <div class="col-span-2 sm:col-span-2">
                                    <x-inputs.group for="addon" inline="true" label="{{__('Toevoeging')}}" :error="$errors->first('editing.contact_information.addon')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.addon"></x-inputs.text>
                                    </x-inputs.group>
                                </div>

                                <div class="col-span-2 sm:col-span-2">
                                    <x-inputs.group for="number" inline="true" label="{{__('Nummer')}}" :error="$errors->first('editing.contact_information.number')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.number"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                            </div>
                            <div class="grid grid-cols-9 gap-9 my-3">
                                <div class="col-span-3 sm:col-span-3">
                                    <x-inputs.group for="zip_code" inline="true" label="{{__('Postcode')}}" :error="$errors->first('editing.contact_information.zip_code')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.zip_code"></x-inputs.text>
                                    </x-inputs.group>
                                </div>

                                <div class="col-span-3 sm:col-span-3">
                                    <x-inputs.group for="city" inline="true" label="{{__('Woonplaats')}}" :error="$errors->first('editing.contact_information.city')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.city"></x-inputs.text>
                                    </x-inputs.group>
                                </div>

                                <div class="col-span-3 sm:col-span-3">
                                    <x-inputs.group for="country" inline="true" label="{{__('Land')}}" :error="$errors->first('editing.contact_information.country')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.country"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </x-slot>
            <x-slot name="footer">
                <x-button.secondary wire:click="$set('showEditModal', false)">{{__('Annuleren')}}</x-button.secondary>
                <x-button.primary type="submit">{{__('Opslaan')}}</x-button.primary>
            </x-slot>
        </x-modal.dialog>
    </form>
</div>
