<div>
    <div class="pb-4">
        <div class="sm:hidden">
            <label for="tabs" class="sr-only">Select a tab</label>
            <!-- Use an "onChange" listener to redirect the user to the selected tab URL. -->
            <select id="tabs" name="tabs" class="block w-full focus:ring-indigo-500 focus:border-indigo-500 border-gray-300 rounded-md">
                <option selected>Gegevens</option>
                <option>Betaalinfo</option>
                <option>Identificatie</option>
                <option>Fase/keten</option>
                <option>Loonstroken</option>
                <option>Contract</option>
            </select>
        </div>
        <div class="hidden sm:block">
            <nav class="relative z-0 rounded-lg shadow flex divide-x divide-gray-200" aria-label="Tabs">
                <!-- Current: "text-gray-900", Default: "text-gray-500 hover:text-gray-700" -->
                @foreach($tabs as $tab)
                    <a wire:click="changeTab('{{$tab}}')" class="@if($currentTab == $tab) text-gray-900 rounded-l-lg @else text-gray-500 hover:text-gray-700 @endif cursor-pointer group relative min-w-0 flex-1 overflow-hidden bg-white py-4 px-4 text-sm font-medium text-center hover:bg-gray-50 focus:z-10">
                        <span>{{$tab}}</span>
                        <span aria-hidden="true" class="@if($currentTab == $tab) bg-blue-500 @else bg-transparent @endif absolute inset-x-0 bottom-0 h-0.5"></span>
                    </a>
                @endforeach
            </nav>
        </div>
    </div>
    <div x-data="{ currenttab: @entangle('currentTab')}">
        <div x-show="currenttab=='Gegevens'" style="display: none;">
            @livewire('employees.employee-basic-info', ['employee' => $employee])
        </div>
        <div x-show="currenttab=='Betaalinfo'" style="display: none;">
            @livewire('employees.employee-bank', ['employee' => $employee])
        </div>
    </div>
</div>
