<div>
    @section('style')
        <style>
            [x-cloak] {
                display: none;
            }
        </style>
    @endsection
    <div class="py-0 bg-white rounded-lg">
        <section aria-labelledby="applicant-information-title" class="space-y-6 lg:col-start-1 lg:col-span-1">
            <div class="bg-white shadow sm:rounded-lg">
                <div class="px-4 py-5 sm:px-6">
                    <h2 class="text-lg leading-6 font-medium text-gray-900 flex justify-between">
                            <span class="flex items-center">
                                {{$employee->name}} {{$employee->surname}}
                                @if(!$employee->extra_information->vog)
                                    <x-icon.exclamationtriangle data-tooltip-target="tooltip-default" class="text-orange-400"></x-icon.exclamationtriangle>
                                    <div id="tooltip-default" role="tooltip" class="inline-block absolute invisible z-10 py-2 px-3 text-sm font-medium text-white bg-gray-900 rounded-lg shadow-sm opacity-0 transition-opacity duration-300 tooltip dark:bg-gray-700">
                                        {{__('VOG ontbreekt')}}
                                        <div class="tooltip-arrow" data-popper-arrow></div>
                                    </div>
                                @endif
                            </span>
                        <x-button.link wire:click="edit" class="h-8 w-8 rounded-full hover:bg-gray-100 hover:text-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-50">
                            <x-icon.edit></x-icon.edit>
                        </x-button.link>
                    </h2>

                    @if($openeditInput)
                        <x-inputs.textbutton type="date" wire:model="editInputVAlue"></x-inputs.textbutton>
                    @else
                        <p wire:click="editValue('employed_date', '{{$employee->employed_date}}')" class="mt-1 max-w-2xl text-sm text-gray-500 hover:underline hover:decoration-dotted cursor-pointer">
                            In dienst sinds
                            <time datetime="{{$employee->employed_date}}">{{date('d F Y', strtotime($employee->employed_date))}}</time>
                        </p>
                    @endif
                </div>
                <div class="border-t border-gray-200 px-4 py-5 sm:px-6">
                    <dl class="grid grid-cols-1 gap-x-4 gap-y-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-gray-500">
                                {{__('Geboortedatum')}}
                            </dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                <span>{{date('d-m-Y', strtotime($employee->personal_information->date_of_birth))}}</span>

                            </dd>
                        </div>
                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-gray-500">
                                {{__('Email')}}
                            </dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                <a style="word-wrap: break-word;" href="mailto:{{$employee->contact_information->email}}">{{$employee->contact_information->email}}</a>
                            </dd>
                        </div>
                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-gray-500">
                                {{__('Telefoon')}}
                            </dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                <a href="tel:{{$employee->contact_information->phone}}">{{$employee->contact_information->phone}}</a>
                            </dd>
                        </div>
                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-gray-500">
                                {{__('Telefoon alternatief')}}
                            </dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                <a href="tel:{{$employee->contact_information->phone_alternative}}">{{$employee->contact_information->phone_alternative}}</a>
                            </dd>
                        </div>
                        <div class="sm:col-span-2">
                            <dt class="text-sm font-medium text-gray-500">
                                {{__('Adres')}}
                            </dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{$employee->contact_information->address}} {{$employee->contact_information->addon}} {{$employee->contact_information->number}}
                                <br>
                                {{$employee->contact_information->zip_code}} {{$employee->contact_information->city}}
                                , {{$employee->contact_information->country}}
                            </dd>
                        </div>
                        <div class="sm:col-span-2">
                            <dt class="text-sm font-medium text-gray-500">
                                {{__('Notitie')}}
                            </dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{$employee->personal_information->notes}}
                            </dd>
                        </div>
                        <div class="sm:col-span-2">
                            <livewire:employees.employee-attachment :employee="$employee"/>
                        </div>
                    </dl>
                </div>
            </div>
        </section>
    </div>

    <form wire:submit.prevent="saveProfile">
        <x-modal.dialog wire:model.defer="showProfileModal" maxWidth="7xl">
            <x-slot name="title">{{__('Medewerken informatie bewerken')}}</x-slot>
            <x-slot name="content">
                <div class="mt-10 sm:mt-0">
                    <div class="md:grid md:grid-cols-3 md:gap-6">
                        <div class="md:col-span-1">
                            <div class="px-4 sm:px-0">
                                <h3 class="text-lg font-medium leading-6 text-gray-900">{{__('Persoonlijke informatie')}}</h3>
                                <p class="mt-1 text-sm text-gray-600">
                                    {{__('Alle persoonlijke informatie van de werknemer')}}
                                </p>
                            </div>
                        </div>
                        <div class="mt-5 md:mt-0 md:col-span-2">
                            <div class="grid grid-cols-6 gap-6">
                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="name" inline="true" label="{{__('Naam')}}" :error="$errors->first('editing.name')">
                                        <x-inputs.text wire:model.defer="editing.name"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="surname" inline="true" label="{{__('Achternaam')}}" :error="$errors->first('editing.surname')">
                                        <x-inputs.text wire:model.defer="editing.surname"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                            </div>
                            <div class="grid grid-cols-6 gap-6 py-2">
                                <div class="col-span-6 sm:col-span-6">
                                    <x-inputs.group for="name" inline="true" label="{{__('Geboortedatum')}}" :error="$errors->first('editing.personal_information.date_of_birth')">
                                        <x-inputs.text type="date" wire:model.defer="editing.personal_information.date_of_birth"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                            </div>
                            <div class="grid grid-cols-6 gap-6 py-4">
                                <div class="col-span-6 sm:col-span-6">
                                    <x-inputs.group for="name" inline="true" label="{{__('Notitie')}}" :error="$errors->first('editing.personal_information.notes')">
                                        <x-inputs.textarea wire:model.defer="editing.personal_information.notes"></x-inputs.textarea>
                                    </x-inputs.group>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr class="my-8">
                    <div class="md:grid md:grid-cols-3 md:gap-6">
                        <div class="md:col-span-1">
                            <div class="px-4 sm:px-0">
                                <h3 class="text-lg font-medium leading-6 text-gray-900">{{__('Contact gegevens')}}</h3>
                                <p class="mt-1 text-sm text-gray-600">
                                    {{__('Alle contact gegevens van de werknemer')}}
                                </p>
                            </div>
                        </div>
                        <div class="mt-5 md:mt-0 md:col-span-2">
                            <div class="grid grid-cols-9 gap-9 my-3">
                                <div class="col-span-5 sm:col-span-5">
                                    <x-inputs.group for="address" inline="true" label="{{__('Straat')}}" :error="$errors->first('editing.contact_information.address')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.address"></x-inputs.text>
                                    </x-inputs.group>
                                </div>

                                <div class="col-span-2 sm:col-span-2">
                                    <x-inputs.group for="addon" inline="true" label="{{__('Toevoeging')}}" :error="$errors->first('editing.contact_information.addon')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.addon"></x-inputs.text>
                                    </x-inputs.group>
                                </div>

                                <div class="col-span-2 sm:col-span-2">
                                    <x-inputs.group for="number" inline="true" label="{{__('Nummer')}}" :error="$errors->first('editing.contact_information.number')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.number"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                            </div>
                            <div class="grid grid-cols-9 gap-9 my-3">
                                <div class="col-span-3 sm:col-span-3">
                                    <x-inputs.group for="zip_code" inline="true" label="{{__('Postcode')}}" :error="$errors->first('editing.contact_information.zip_code')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.zip_code"></x-inputs.text>
                                    </x-inputs.group>
                                </div>

                                <div class="col-span-3 sm:col-span-3">
                                    <x-inputs.group for="city" inline="true" label="{{__('Woonplaats')}}" :error="$errors->first('editing.contact_information.city')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.city"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-3 sm:col-span-3">
                                    <x-inputs.group for="country" inline="true" label="{{__('Land')}}" :error="$errors->first('editing.contact_information.country')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.country"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                            </div>
                            <div class="grid grid-cols-6 gap-6">
                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="name" inline="true" label="{{__('Telefoon')}}" :error="$errors->first('editing.contact_information.phone')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.phone"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="surname" inline="true" label="{{__('Telefoon alternatief')}}" :error="$errors->first('editing.contact_information.phone_alternative')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.phone_alternative"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                            </div>
                            <div class="grid grid-cols-6 gap-6">
                                <div class="col-span-6 sm:col-span-3">
                                    <x-inputs.group for="name" inline="true" label="{{__('Email')}}" :error="$errors->first('editing.contact_information.email')">
                                        <x-inputs.text wire:model.defer="editing.contact_information.email"></x-inputs.text>
                                    </x-inputs.group>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </x-slot>
            <x-slot name="footer">
                <x-button.secondary wire:click="$set('showProfileModal', false)">{{__('Annuleren')}}</x-button.secondary>
                <x-button.primary type="submit">{{__('Opslaan')}}</x-button.primary>
            </x-slot>
        </x-modal.dialog>
    </form>
</div>
