<div>
    <dt class="text-sm font-medium text-gray-500">
        {{__('Bijlagen')}}
    </dt>
    <dd class="mt-1 text-sm text-gray-900">
        <ul role="list" class="border border-gray-200 rounded-md divide-y divide-gray-200">
            @foreach($employee->attachments as $attachment)
                <li class="pl-3 pr-4 py-3 flex items-center justify-between text-sm">
                    <div class="w-0 flex-1 flex items-center">
                        @if(in_array($attachment->type, $filetypeimage))
                            <x-icon.image class="text-gray-400"/>
                        @else
                            <x-icon.document class="text-gray-400"/>
                        @endif
                        <span class="ml-2 flex-1 w-0 truncate">{{str_replace('_', ' ', $attachment->name) ?? 'No name given'}}</span>
                    </div>
                    <div class="ml-4 flex-shrink-0">
                        <a href="{{$employee->getAttachment($attachment->attachment)}}" target="_blank" class="font-medium text-blue-600 hover:text-blue-500">
                            {{__('Bekijken')}}
                        </a>
                        <span>|</span>
                        <x-button.link wire:click="showDeleteModalMethod({{$attachment}})" textcolor="text-red-500" class="font-medium text-red-500 hover:text-red-600">
                            {{__('Verwijderen')}}
                        </x-button.link>
                    </div>
                </li>
            @endforeach
            <li class="pl-3 pr-4 py-3 flex items-center justify-between text-sm">
                <div class="w-0 flex-1 flex items-center">
                    <span class="py-0 flex justify-between items-center cursor-pointer" wire:click="$toggle('showAddAttachmentModal')">
                        <span class="rounded-full border-2 border-dashed border-blue-300 flex items-center justify-center text-blue-400">
                            <svg class="h-5 w-5" x-description="Heroicon name: solid/plus-sm" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                <path fill-rule="evenodd" d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z" clip-rule="evenodd"></path>
                            </svg>
                        </span>
                        <span class="ml-4 text-sm font-medium text-blue-600 group-hover:text-blue-500">Bijlage toevoegen</span>
                    </span>
                </div>
            </li>
        </ul>
    </dd>

    <form wire:submit.prevent="saveAttachments">
        <x-modal.dialog wire:model.defer="showAddAttachmentModal" maxWidth="7xl">
            <x-slot name="title">{{__('Bijlagen toevoegen')}}</x-slot>
            <x-slot name="content">



{{--                <div>--}}
{{--                    <div--}}
{{--                        class="flex h-screen justify-center items-center"--}}
{{--                        x-data="drop_file_component()">--}}
{{--                        <div--}}
{{--                            class="py-6 w-96 rounded border-dashed border-2 flex flex-col justify-center items-center"--}}
{{--                            x-bind:class="dropingFile ? 'bg-gray-400 border-gray-500' : 'border-gray-500 bg-gray-200'"--}}
{{--                            x-on:drop="dropingFile = false"--}}
{{--                            x-on:drop.prevent="handleFileDrop($event)"--}}
{{--                            x-on:dragover.prevent="dropingFile = true"--}}
{{--                            x-on:dragleave.prevent="dropingFile = false">--}}
{{--                            <svg xmlns="http://www.w3.org/2000/svg" class="h-16 w-16" fill="none" viewBox="0 0 24 24" stroke="currentColor">--}}
{{--                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 13h6m-3-3v6m-9 1V7a2 2 0 012-2h6l2 2h6a2 2 0 012 2v8a2 2 0 01-2 2H5a2 2 0 01-2-2z" />--}}
{{--                            </svg>--}}
{{--                            <div class="text-center" wire:loading.remove wire.target="files">Drop Your Files Here</div>--}}
{{--                            <div class="mt-1" wire:loading.flex wire.target="files">--}}
{{--                                <svg class="animate-spin -ml-1 mr-3 h-5 w-5 text-gray-700" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">--}}
{{--                                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>--}}
{{--                                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>--}}
{{--                                </svg>--}}
{{--                                <div>Processing Files</div>--}}
{{--                            </div>--}}
{{--                        </div>--}}
{{--                    </div>--}}

{{--                    --}}
{{--                </div>--}}






                <div x-data="drop_file_component()">
                    <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-md">
                        <div class="space-y-1 text-center">
                            <svg class="mx-auto h-12 w-12 text-gray-400" stroke="currentColor" fill="none" viewBox="0 0 48 48" aria-hidden="true">
                                <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            <div class="flex text-sm text-gray-600">
                                <label for="file-upload" class="relative cursor-pointer bg-white rounded-md font-medium text-indigo-600 hover:text-indigo-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-indigo-500">
                                    <span>{{__('Bestand kiezen')}}</span>
                                    <input wire:model="newAttachments" name="file-upload" id="file-upload" type="file" class="sr-only" multiple>
                                </label>
                                <p class="pl-1">{{__('of slepen en neerzetten')}}</p>
                            </div>
                            <p class="text-xs text-gray-500">
                                PNG, JPG, PDF, WORD, EXCEL max 10MB </p>
                        </div>
                    </div>
                    @if(!empty($newAttachments))
                        <ul role="list" class="grid grid-cols-2 gap-x-4 gap-y-8 sm:grid-cols-3 sm:gap-x-6 lg:grid-cols-4 xl:gap-x-8">
                            @foreach($newAttachments as $key => $newAttachment)
                                @if($newAttachment->extension() == 'png' || $newAttachment->extension() == 'jpg' || $newAttachment->extension() == 'png' || $newAttachment->extension() == 'jpeg')
                                    <li class="relative">
                                        <div class="group block w-full aspect-w-10 aspect-h-7 rounded-lg bg-gray-100 focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-offset-gray-100 focus-within:ring-indigo-500 overflow-hidden">
                                            <img src="{{$newAttachment->temporaryUrl()}}" alt="" class="object-cover pointer-events-none">
                                            <x-icon.cross wire:click="removeFile({{$key}})" class="text-red-600 cursor-pointer" style="position: absolute;top: 5px;right: 5px;"/>
                                        </div>
                                        <p class="mt-2 block text-sm font-medium text-gray-900 truncate pointer-events-none">{{$newAttachment->getClientOriginalName()}}</p>
                                        <p class="block text-sm font-medium text-gray-500 pointer-events-none">{{number_format($newAttachment->getSize() / 1048576,2)}}
                                            MB</p>

                                        @error('newAttachments.'.$key)
                                        <span class="text-red-600">{{$message}}</span> @enderror
                                    </li>
                                @else
                                    <li class="relative">
                                        <div class="group block w-full aspect-w-10 aspect-h-7 rounded-lg bg-gray-100 focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-offset-gray-100 focus-within:ring-indigo-500 overflow-hidden">
                                            <x-icon.document class="text-cool-gray-500 h-32 w-32"/>
                                            <x-icon.cross wire:click="removeFile({{$key}})" class="text-red-600 cursor-pointer" style="position: absolute;top: 5px;right: 5px;"/>
                                        </div>
                                        <p class="mt-2 block text-sm font-medium text-gray-900 truncate pointer-events-none">{{$newAttachment->getClientOriginalName()}}</p>
                                        <p class="block text-sm font-medium text-gray-500 pointer-events-none">{{number_format($newAttachment->getSize() / 1048576,2)}}
                                            MB</p>
                                        @error('newAttachments.'.$key)
                                        <span class="text-red-600">{{$message}}</span> @enderror
                                    </li>
                                @endif
                            @endforeach
                        </ul>
                    @endif
                </div>
            </x-slot>
            <x-slot name="footer">
                <x-button.secondary wire:click="$set('showAddAttachmentModal', false)">{{__('Annuleren')}}</x-button.secondary>
                <x-button.primary type="submit">{{__('Opslaan')}}</x-button.primary>
            </x-slot>
        </x-modal.dialog>
    </form>

    <form wire:submit.prevent="deleteFile">
        <x-modal.confirmation wire:model.defer="showDeleteModal">
            <x-slot name="title">{{__('Bestand(en) verwijderen')}}</x-slot>
            <x-slot name="content">{{__('Deze actie kan niet ongedaan worden gemaakt.')}}</x-slot>
            <x-slot name="footer">
                <x-button.danger type="submit">{{__('Verwijderen')}}</x-button.danger>
                <x-button.secondary wire:click="$set('showDeleteModal', false)">{{__('Annuleren')}}</x-button.secondary>
            </x-slot>
        </x-modal.confirmation>
    </form>
</div>
