@props(['type'])
<div>
    <div class="mt-1 flex rounded-md shadow-sm drop-shadow-xl">
        <div class="relative flex items-stretch flex-grow focus-within:z-10">
            <input {{ $attributes }} type="{{$type ?? 'text'}}" @if($type == 'date') style="padding: 2px;" @endif class="block w-full rounded-none rounded-l-md pl-10 sm:text-sm border-gray-300">
        </div>
        <button type="button" wire:click="saveInputValue()" class="-ml-px relative inline-flex items-center space-x-1 px-1 py-1 border border-gray-300 text-sm font-medium text-green-700 bg-gray-50 hover:bg-gray-100 focus:outline-none">
            <x-icon.check></x-icon.check>
        </button>
        <button type="button" wire:click="cancelInputValue()" class="-ml-px relative inline-flex items-center space-x-1 px-1 py-1 border border-gray-300 text-sm font-medium rounded-r-md text-red-700 bg-gray-50 hover:bg-gray-100 focus:outline-none">
            <x-icon.times></x-icon.times>
        </button>
    </div>
</div>
