<x-guest-layout>
    <div class="min-h-full flex flex-col justify-center py-12 sm:px-6 lg:px-8">
        <div class="sm:mx-auto sm:w-full sm:max-w-md">
            <x-logo></x-logo>
            <h2 class="mt-6 text-center text-3xl font-extrabold text-gray-900">
                {{__('Log in op uw account')}}
            </h2>
        </div>


        <div class="mt-8 sm:mx-auto sm:w-full sm:max-w-md">
            <div class="bg-white py-8 px-4 shadow sm:rounded-lg sm:px-10">
                <x-validation-errors></x-validation-errors>
                <form class="space-y-6" method="POST" action="{{ route('login') }}">
                    @csrf
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700">
                            {{__('Email')}}
                        </label>
                        <div class="mt-1">
                            <input id="email" name="email" type="email" value="{{old('email')}}" autocomplete="email" required="" class="@error('email') border-red-300 text-red-900 placeholder-red-300 focus:outline-none focus:ring-red-500 focus:border-red-500 @enderror appearance-none block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm placeholder-gray-400 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm"/>
                        </div>
                        @error('email')
                            <p class="mt-2 text-sm text-red-600" id="email-error">{!! $errors->first('email', ':message') !!}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="password" class="block text-sm font-medium text-gray-700">
                            {{__('Wachtwoord')}}
                        </label>
                        <div class="mt-1">
                            <input id="password" name="password" type="password" value="{{old('password')}}" autocomplete="current-password" required="" class="@error('password') border-red-300 text-red-900 placeholder-red-300 focus:outline-none focus:ring-red-500 focus:border-red-500 @enderror appearance-none block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm placeholder-gray-400 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm"/>
                        </div>
                        @error('password')
                        <p class="mt-2 text-sm text-red-600" id="email-error">{!! $errors->first('password', ':message') !!}</p>
                        @enderror
                    </div>

                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <input id="remember-me" name="remember-me" type="checkbox" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded"/>
                            <label for="remember-me" class="ml-2 block text-sm text-gray-900">
                                {{__('Onthoud mij')}}
                            </label>
                        </div>

                        <div class="text-sm">
                            <a href="#" class="font-medium text-blue-600 hover:text-blue-500">
                                {{__('Wachtwoord vergeten?')}}
                            </a>
                        </div>
                    </div>

                    <div>
                        <button type="submit"
                                class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            {{__('Aanmelden')}}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{--    <x-jet-authentication-card>--}}
    {{--        <x-slot name="logo">--}}
    {{--            <x-jet-authentication-card-logo />--}}
    {{--        </x-slot>--}}

    {{--        <x-jet-validation-errors class="mb-4" />--}}

    {{--        @if (session('status'))--}}
    {{--            <div class="mb-4 font-medium text-sm text-green-600">--}}
    {{--                {{ session('status') }}--}}
    {{--            </div>--}}
    {{--        @endif--}}

    {{--        <form method="POST" action="{{ route('login') }}">--}}
    {{--            @csrf--}}

    {{--            <div>--}}
    {{--                <x-jet-label for="email" value="{{ __('Email') }}" />--}}
    {{--                <x-jet-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')" required autofocus />--}}
    {{--            </div>--}}

    {{--            <div class="mt-4">--}}
    {{--                <x-jet-label for="password" value="{{ __('Password') }}" />--}}
    {{--                <x-jet-input id="password" class="block mt-1 w-full" type="password" name="password" required autocomplete="current-password" />--}}
    {{--            </div>--}}

    {{--            <div class="block mt-4">--}}
    {{--                <label for="remember_me" class="flex items-center">--}}
    {{--                    <x-jet-checkbox id="remember_me" name="remember" />--}}
    {{--                    <span class="ml-2 text-sm text-gray-600">{{ __('Remember me') }}</span>--}}
    {{--                </label>--}}
    {{--            </div>--}}

    {{--            <div class="flex items-center justify-end mt-4">--}}
    {{--                @if (Route::has('password.request'))--}}
    {{--                    <a class="underline text-sm text-gray-600 hover:text-gray-900" href="{{ route('password.request') }}">--}}
    {{--                        {{ __('Forgot your password?') }}--}}
    {{--                    </a>--}}
    {{--                @endif--}}

    {{--                <x-jet-button class="ml-4">--}}
    {{--                    {{ __('Log in') }}--}}
    {{--                </x-jet-button>--}}
    {{--            </div>--}}
    {{--        </form>--}}
    {{--    </x-jet-authentication-card>--}}
</x-guest-layout>
