<?php

namespace Database\Seeders;

use Employees\Models\Employee;
use Employees\Models\EmployeeBankInformation;
use Employees\Models\EmployeeContactInformation;
use Employees\Models\EmployeeExtraInformation;
use Employees\Models\EmployeePersonalInformation;
use Illuminate\Database\Seeder;

class EmployeeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Employee::factory(500)
            ->has(EmployeeBankInformation::factory(1),'bank_information')
            ->has(EmployeeContactInformation::factory(1),'contact_information')
            ->has(EmployeePersonalInformation::factory(1),'personal_information')
            ->has(EmployeeExtraInformation::factory(1),'extra_information')
            ->create()
            ->each(function($user) {
        });
    }
}
