<?php

namespace Database\Factories\Employees\Models;

use Employees\Models\EmployeePersonalInformation;
use Illuminate\Database\Eloquent\Factories\Factory;

class EmployeePersonalInformationFactory extends Factory
{
    protected $model = EmployeePersonalInformation::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'bsn' => $this->faker->numberBetween(111111111, 999999999),
            'date_of_birth' => $this->faker->dateTimeBetween('1960-01-01', '2003-12-31')->format('Y-m-d'),
            'birthplace' => $this->faker->city,
            'birthland' => $this->faker->countryCode,
            'initials' => $this->faker->randomLetter,
            'salutation' => $this->faker->randomElement($array = array ('Mevr','Dhr')),
            'marital_status' => $this->faker->randomElement($array = array ('Geh','Ong')),
            'notes' => $this->faker->text(100),
        ];
    }
}
