<?php

namespace Database\Factories\Employees\Models;

use Employees\Models\Employee;
use Illuminate\Database\Eloquent\Factories\Factory;

class EmployeeFactory extends Factory
{

    protected $model = Employee::class;
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->firstName(),
            'surname' => $this->faker->lastName(),
            'call_name' => $this->faker->firstName(),
            'employed_date' => $this->faker->dateTimeBetween('1980-01-01', 'now'),
            'active' => $this->faker->boolean,
        ];
    }
}
