<?php

namespace App\Traits;

use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Models\Activity;

trait ModifyLogCauser
{
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->logExcept(['id','updated_at', 'created_at']);
        // Chain fluent methods for configuration options
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->causer_name = $activity->causer->name ?? $activity->causer;
        $activity->subject_type = str_replace('AppModels', '', stripslashes($activity->subject_type));
        $activity->causer_type = str_replace('AppModels', '', stripslashes($activity->causer_type));
    }
}
