<?php

namespace App\Traits;

trait HasBulkActions
{
    public $selectPage = false;
    public $selectAll = false;
    public $selected = [];

    public function updatedSelectPage($value)
    {
        if ($value) return $this->selectPageRows();
        $this->selected = [];
    }

    public function updatedSelected()
    {
        $this->selectAll = false;
        $this->selectPage = false;
    }

    public function selectPageRows()
    {
        $this->selected = $this->modelrows->pluck('id')->map(fn($id) => (string) $id);
    }

    public function selectAll()
    {
        $this->selectAll = true;
    }

    public function getSelectedRowsQueryProperty()
    {
          return (clone $this->modelrowsQuery)->with('contact_information', 'bank_information')
              ->unless($this->selectAll, fn($query) => $query->whereKey($this->selected));
    }
}
