<?php

namespace App\Providers;

use App\Breadcrumbs\Breadcrumbs;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;
use Livewire\Component;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Blade::directive('maskbank', function ($string) {
            return "<?php echo substr($string, 0, 2) . str_repeat('*', strlen($string) - (strlen($string) > 5 ? 5 : 0)) . substr($string, -3) ?>";
        });
        Blade::directive('bsn', function ($string) {
            return "<?php echo str_repeat('*', strlen($string)) ?>";
        });

        Request::macro('breadcrumbs', function () {
            return new Breadcrumbs($this);
        });

        Builder::macro('search', function ($field, $string) {
            return $string ? $this->where($field, 'like', '%'.$string.'%') : $this;
        });

        Component::macro('notify', function ($message) {
            $this->dispatchBrowserEvent('notify', $message);
        });
        Component::macro('notifygreen', function ($message) {
            $this->dispatchBrowserEvent('notifygreen', $message);
        });
        Component::macro('notifyerror', function ($message) {
            $this->dispatchBrowserEvent('notifyerror', $message);
        });

        Builder::macro('toCsv', function () {
            $results = $this->get();
            if ($results->count() < 1) { return; }

            $titles = implode(',', array_keys((array) $results->first()->getAttributes()));

            $values = $results->map(function ($result) {
                return implode(',', collect($result->getAttributes())->map(function ($thing){
                    return '"'.$thing.'"';
                })->toArray());
            });

            $values->prepend($titles);
            return $values->implode("\n");
        });
    }
}
