<?php

namespace App\Http\Livewire\Logs;

use Livewire\Component;
use Livewire\WithPagination;
use Spatie\Activitylog\Models\Activity;

class Logstable extends Component
{
    use WithPagination;

    public $detailopen;
    public $logdetails;

    public function render()
    {
        $logs = Activity::paginate(20);
        return view('livewire.logs.logstable', ['logs' => $logs]);
    }

    public function openDetails($log, $key)
    {
        $this->detailopen[$key] = true;
        $this->logdetails = $log['properties'];
    }

    public function closeDetails()
    {
        $this->detailopen = [];
    }
}
