<?php

namespace App\Http\Livewire\Employees;

use App\Traits\HasCachedRows;
use Employees\Models\Employee;
use Livewire\Component;

class EmployeeTabs extends Component
{
    use HasCachedRows;
    public Employee $employee;
    public $componentName = 'employee-basic-info';
    public $tabs = ['Gegevens', 'Betaalinfo', 'Identificatie', 'Fase/Keten', 'Loonstroken', 'Contract'];
    public $currentTab = 'Gegevens';

    public function mount(Employee $employee)
    {
        $this->employee = $employee;
    }

    public function changeTab($tab)
    {
        $this->componentName = 'employee-bank';
        $this->currentTab = $tab;
        $this->render();
    }
    public function render()
    {
        return view('livewire.employees.employee-tabs');
    }
}
