<?php

namespace App\Http\Livewire\Employees;

use Employees\Models\Employee;
use Employees\Models\EmployeeAttachments;
use Illuminate\Support\Facades\Storage;
use Livewire\Component;
use Livewire\WithFileUploads;

class EmployeeAttachment extends Component
{
    use WithFileUploads;


    public Employee $employee;
    public $newAttachments = [];
    public $filetypeimage = ['jpg', 'png', 'gif', 'jpeg'];
    public $showAddAttachmentModal = false;
    public $showDeleteModal = false;
    public $toBeDeletedAttachment;
    public $files = [];

    public function mount(Employee $employee)
    {
        $this->employee = $employee;
        $this->showDeleteModal = false;
    }

    public function updatedNewAttachment()
    {
        $this->validate([
            'newAttachments.*' => 'file|max:10000'
        ]);
    }

    public function removeFile($key)
    {
        unset($this->newAttachments[$key]);
    }

    public function removeFileFromStorage()
    {

        if (Storage::disk('attachments')->delete($this->toBeDeletedAttachment['attachment'])) {
            EmployeeAttachments::find($this->toBeDeletedAttachment['id'])->delete();
        } else{
            $att = EmployeeAttachments::find($this->toBeDeletedAttachment['id']);
            if ($att){
                $att->delete();
            }
        }
        $this->employee->refresh();
    }

    public function saveAttachments()
    {
        $this->showAddAttachmentModal = false;
        $this->validate([
            'newAttachments.*' => 'file|max:10000'
        ]);
        foreach ($this->newAttachments as $attachment) {
            $filename = $attachment->store('/', 'attachments');

            $type = $attachment->extension();
            // Use $attachment->hashName() instead of getClientOriginalName();
            $originalname = pathinfo($attachment->getClientOriginalName(), PATHINFO_FILENAME);
            $originalname = preg_replace('/[^A-Za-z0-9\_\- ]/', '', $originalname);
            $originalname = trim($originalname);
            $originalname = str_replace(' ', '_', $originalname);
            $originalname = mb_ereg_replace("([^\w\s\d\-_~,;\[\]\(\).])", '', $originalname);
            $originalname = mb_ereg_replace("([\.]{2,})", '', $originalname);

            $this->employee->attachments()->create([
                'name' => $originalname,
                'attachment' => $filename,
                'type' => $type,
            ]);
        }
        $this->cleanupOldUploads();
        $this->newAttachments = [];
        $this->employee->refresh();
    }

//    public function updatedFiles()
//    {
////        $this->newAttachments = $this->files;
//        dd($this->files, $this->newAttachments);
//    }

    public function showDeleteModalMethod($attachment)
    {
        $this->toBeDeletedAttachment = $attachment;
        $this->showDeleteModal = true;
    }

    public function deleteFile()
    {
        $this->showDeleteModal = false;
        $this->removeFileFromStorage();
    }

    public function render()
    {
        return view('livewire.employees.employee-attachment');
    }
}
