<?php

namespace App\Http\Livewire\Companies;

use App\Traits\HasCachedRows;
use Companies\Models\Company;
use Livewire\Component;

class CompanyTabs extends Component
{
    use HasCachedRows;

    public Company $company;

    public $currentTab = 'contactpersoon';

    public function mount(Company $company)
    {
        $this->company = $company;
    }

    public function changeTab($tab)
    {
        $this->currentTab = $tab;
        $this->render();
    }

    public function render()
    {
        return view('livewire.companies.company-tabs');
    }
}
