<?php

namespace App\Http\Livewire\Companies;

use Companies\Models\Company;
use Illuminate\Support\Arr;
use Livewire\Component;

class CompanyBasicInfo extends Component
{
    public Company $company;
    public Company $editing;
    public $editValues = false;

    public function rules()
    {
        return [
            'editing.name' => 'required',
            'editing.email' => 'required|email',
            'editing.address' => 'nullable',
            'editing.number' => 'nullable|numeric',
            'editing.addon' => 'nullable',
            'editing.zip_code' => 'nullable',
            'editing.city' => 'nullable',
            'editing.country' => 'nullable',
            'editing.phone' => 'nullable|numeric',
            'editing.note' => 'nullable',
            'editing.website' => 'nullable',
            'editing.kvk' => 'required|numeric',
            'editing.active' => 'nullable',
        ];
    }

    public function messages()
    {
        return [
            'editing.name.required' => __('Naam is verplicht'),
            'editing.email.required' => __('Email is verplicht'),
            'editing.email.email' => __('Email is niet geldig'),
            'editing.number.numeric' => __('Nummer mag alleen maar uit cijfers bestaan'),
            'editing.phone.numeric' => __('Telefoon mag alleen maar uit cijfers bestaan'),
            'editing.kvk.numeric' => __('KvK nummer mag alleen maar uit cijfers bestaan'),
        ];
    }

    public function mount(Company $company)
    {
        $this->company = $company;
        $this->editing = $company;
    }

    public function saveCompanyBasicInfo()
    {
        $this->validate();

        if ($this->editing->save()) {
           $this->notify(trans('Bedrijfsgegevens is bijgewerkt'));
           $this->editValues = false;
        }
        $this->company->refresh();
    }

    public function render()
    {
        return view('livewire.companies.company-basic-info');
    }


}
