<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class MakeModelForModule extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'module:model';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a model for a module';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $moduleName = $this->ask('Enter module name');
        $modelName = $this->ask('Enter model name');
        $validator = Validator::make([
            'model_name' => $modelName,
            'module_name' => $moduleName,
        ], [
            'model_name' => ['required'],
            'module_name' => ['required']
        ]);

        if ($validator->fails()) {
            $this->info('Model not created.');

            foreach ($validator->errors()->all() as $error) {
                $this->info($error);
            }
            return 1;
        }
        $this->makeModel($moduleName, $modelName);
        return $moduleName . $modelName;
    }

    private function makeModel($moduleName, $modelName)
    {
        $model = ucfirst($modelName);
        $mainSpace =  "namespace App\\$moduleName";
//        $tableName = $tableName ? 'protected $table = ' . "'$tableName';" : '';
        $content = "<?php

                    $mainSpace

                    use Illuminate\Database\Eloquent\Model;

                    class {$model} extends Model
                    {

                    }
                    ";
        $folder = "App/$moduleName/";

        if (!is_dir($folder)) {
            File::makeDirectory($folder, $mode = 0777, true, true);
        }

        $written = Storage::disk('app')->put('Models/' . $moduleName . '/' . $modelName . '.php', $content);

        if ($written) {
            $this->info('Created new model ' . $modelName . '.php in App\Models\\' . $moduleName);
        } else {
            $this->info('Something went wrong');
        }

    }
}
