<?php

namespace Employees\Models;

use App\Traits\ModifyLogCauser;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;

class EmployeeBankInformation extends Model
{
    use HasFactory, LogsActivity, ModifyLogCauser;

    protected $fillable = ['main_bank'];

    protected $casts = [
        'owner' => 'encrypted',
        'iban' => 'encrypted',
        'valid_until' => 'encrypted',
    ];
}
