<?php

namespace Employees\Models;

use App\Traits\ModifyLogCauser;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Storage;
use Spatie\Activitylog\Traits\LogsActivity;

class Employee extends Model
{
    use HasFactory, LogsActivity, ModifyLogCauser, SoftDeletes;

    protected $fillable = ['name', 'surname', 'call_name', 'employed_date', 'active'];

    public function contact_information()
    {
        return $this->hasOne(EmployeeContactInformation::class, 'employee_id', 'id');
    }

    public function extra_information()
    {
        return $this->hasOne(EmployeeExtraInformation::class, 'employee_id', 'id');
    }

    public function bank_information()
    {
        return $this->hasMany(EmployeeBankInformation::class, 'employee_id', 'id')->orderBy('id', 'DESC');
    }

    public function attachments()
    {
        return $this->hasMany(EmployeeAttachments::class);
    }

    public function getAttachment($attachment)
    {
        return Storage::disk('attachments')->url($attachment);
    }

    public function personal_information()
    {
        return $this->hasOne(EmployeePersonalInformation::class);
    }

    public function getActiveColorAttribute()
    {
        return [
          '1' => 'green',
          '0' => 'red'
        ][$this->active];
    }
}
